#include "Bdef.h"

void ArgCheck00(ConTxt, RoutType, routine, scope, uplo, diag, m, n, lda, nprocs, prows, pcols)
int  ConTxt;
int  RoutType;
char  *routine;
char  scope;
char  uplo;
char  diag;
int  m;
int  n;
int  lda;
int  nprocs;
int  *prows;
int  *pcols;
{
#if (BlacsDebugLvl > 0)
   char *srcdest;
   int i=1, prow, pcol;
   BLACSCONTEXT *ctxt;

   MGetConTxt(ConTxt, ctxt);

   if ( (scope != 'r') && (scope != 'c') && (scope != 'a') )
      BlacsErr(ConTxt, -1, routine, "Unknown scope, scope=%c", scope);
   if ( (uplo != 'u') && (uplo != 'l') )
   {
      if (RoutType != RT_COMB)
         BlacsWarn(ConTxt, -1, routine,
                   "UPLO=%c, will be assumed to mean LOWER", uplo);
      else i = 0;  /* combine aux, for rect. matrix */
   }
   if ( (diag != 'u') && (diag != 'n') )
   {
      if (i) BlacsWarn(ConTxt, -1, routine,
                       "DIAG=%c, will be assumed to mean NON-UNIT", diag);
   }
   if (m * n != 0)
   {
      if (m < 0)
         BlacsErr(ConTxt, -1, routine, "Illegal number of rows, M=%d", m);
      if (n < 0)
         BlacsErr(ConTxt, -1, routine, "Illegal number of columns, N=%d", n);
      if (lda < m)
         BlacsWarn(ConTxt, -1, routine,
                   "Illegal LDA, LDA=%d, M=%d; LDA assumed to be %d",
                   lda, m, m);
   }

   if ( (RoutType == RT_RV) || (RoutType == RT_BR) ) srcdest = "SRC";
   else srcdest = "DEST";

   if (RoutType == RT_SD)
   {
      if ( (nprocs > ctxt->Ng) || (nprocs < 0) )
         BlacsErr(ConTxt, -1, routine,
                  "Trying to send to %d procs, but only %d in grid",
                  nprocs, ctxt->Ng);
   }

   for (i=0; i < nprocs; i++)
   {
      prow = prows[i];
      pcol = pcols[i];

      if ( (prow < 0) || (prow >= ctxt->nprow) )
      {
         if ( !((RoutType == RT_COMB) && (prow == -1)) )
            BlacsErr(ConTxt, -1, routine, "R%s out of range; R%s=%d, NPROW=%d",
                     srcdest, srcdest, prow, ctxt->nprow);
      }
      if ( (pcol < 0) || (pcol >= ctxt->npcol) )
      {
         if ( !((RoutType == RT_COMB) && (prow == -1)) )
            BlacsErr(ConTxt, -1, routine, "C%s out of range; C%s=%d, NPCOL=%d",
                     srcdest, srcdest, pcol, ctxt->npcol);
      }
      if (RoutType == RT_SD)  /* point to point send */
      {
         if ( (prow == ctxt->myrow) && (pcol == ctxt->mycol) )
            BlacsWarn(ConTxt, -1, routine, "Node sending message to itself");
      }
      else if (RoutType == RT_RV)  /* point to point send */
      {
         if ( (prow == ctxt->myrow) && (pcol == ctxt->mycol) )
            BlacsWarn(ConTxt, -1, routine, "Node recving message from itself");
      }
      else if (RoutType == RT_BR) /* broadcast/recv */
      {
         if ( (prow == ctxt->myrow) && (pcol == ctxt->mycol) )
            BlacsErr(ConTxt, -1, routine,
                     "Node tries to recv its own broadcast");

         if (scope == 'r')
         {
            if (ctxt->myrow != prow)
               BlacsWarn(ConTxt, -1, routine,
                         "Row broadcast: MYROW=%d, but RSRC=%d",
                         ctxt->myrow, prow);
         }
         else if (scope == 'c')
         {
            if (ctxt->mycol != pcol)
            {
               BlacsErr(ConTxt, -1, routine,
                        "Column broadcast: MYCOL=%d, but CSRC=%d",
                        ctxt->mycol, pcol);
            }
         }
      }
   }
#endif
}
