
-- -----------------------------------------------------
-- Sequence used to generator non pk fields
-- -----------------------------------------------------
DROP SEQUENCE generator IF EXISTS;
CREATE SEQUENCE generator AS INTEGER START WITH 0 INCREMENT BY 1;

-- -----------------------------------------------------
-- Table remoteInfo
-- -----------------------------------------------------
DROP TABLE remoteInfo IF EXISTS CASCADE;
CREATE CACHED TABLE remoteInfo (
  idremoteInfo INT GENERATED BY DEFAULT AS IDENTITY,
  protocol VARCHAR(45) NULL ,
  port INT NULL ,
  dbName VARCHAR(45) NULL ,
  dbFullname VARCHAR(512) NULL ,
  dbType VARCHAR(128) NULL ,
  server VARCHAR(256) NULL ,
  remoteDir VARCHAR(256) NULL ,
  PRIMARY KEY (idremoteInfo) )



-- -----------------------------------------------------
-- Table localInfo
-- -----------------------------------------------------
DROP TABLE localInfo IF EXISTS CASCADE;
CREATE CACHED TABLE localInfo (
  idlocalInfo INT GENERATED BY DEFAULT AS IDENTITY,
  offlineDirectory VARCHAR(256) NULL ,
  versionDirectory VARCHAR(256) NULL ,
  frequency INT NULL ,
  dolinkcopy BOOLEAN NULL ,
  logfile BOOLEAN NULL ,
  releaseFile VARCHAR(45) NULL ,
  releaseRegexp VARCHAR(128) NULL ,
  remoteFiles VARCHAR(128) NULL ,
  remoteExcludedFiles VARCHAR(128) NULL ,
  localFiles VARCHAR(128) NULL ,
  nversions INT NULL ,
  PRIMARY KEY (idlocalInfo) )


-- -----------------------------------------------------
-- Table bank
-- -----------------------------------------------------
DROP TABLE bank IF EXISTS CASCADE;
CREATE CACHED TABLE bank (
  idbank INT GENERATED BY DEFAULT AS IDENTITY,
  name VARCHAR(45) NULL,
  PRIMARY KEY (idbank))
  

-- -----------------------------------------------------
-- Table configuration
-- -----------------------------------------------------
DROP TABLE configuration IF EXISTS CASCADE;
CREATE CACHED TABLE configuration (
  idconfiguration BIGINT,
  ref_idremoteInfo INT NOT NULL ,
  ref_idlocalInfo INT NOT NULL ,
  ref_idbank INT NOT NULL ,
  date DATETIME NULL ,
  file VARCHAR(256) NULL ,
  insert_hack INT NULL,
  PRIMARY KEY (idconfiguration) ,
  CONSTRAINT fk_configuration_remoteInfo1
    FOREIGN KEY (ref_idremoteInfo )
    REFERENCES remoteInfo (idremoteInfo )
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT fk_configuration_localInfo1
    FOREIGN KEY (ref_idlocalInfo )
    REFERENCES localInfo (idlocalInfo )
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT fk_configuration_bank1
    FOREIGN KEY (ref_idbank )
    REFERENCES bank (idbank )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)


CREATE INDEX fk_configuration_remoteInfo1 ON configuration (ref_idremoteInfo ASC) ;

CREATE INDEX fk_configuration_localInfo1 ON configuration (ref_idlocalInfo ASC) ;

CREATE INDEX fk_configuration_bank1 ON configuration (ref_idbank ASC) ;


-- -----------------------------------------------------
-- Table updateBank
-- -----------------------------------------------------
DROP TABLE updateBank IF EXISTS CASCADE;
CREATE CACHED TABLE updateBank (
  idupdateBank INT GENERATED BY DEFAULT AS IDENTITY,
  ref_idconfiguration BIGINT NOT NULL ,
  release VARCHAR(45) NULL ,
  productionDirectoryPath VARCHAR(256) NULL ,
  productionDirectoryDeployed BOOLEAN NULL ,
  sizeDownload VARCHAR(45) NULL ,
  sizeRelease VARCHAR(45) NULL ,
  startTime DATETIME NULL ,
  endTime DATETIME NULL ,
  elapsedTime VARCHAR(45) NULL ,
  update BOOLEAN NULL ,
  nbSessions INT NULL ,
  idLastSession BIGINT NULL ,
  PRIMARY KEY (idupdateBank) ,
  CONSTRAINT fk_updateBank_configuration1
    FOREIGN KEY (ref_idconfiguration )
    REFERENCES configuration (idconfiguration )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)


CREATE INDEX fk_updateBank_configuration1 ON updateBank (ref_idconfiguration ASC) ;


-- -----------------------------------------------------
-- Table sessionTask
-- -----------------------------------------------------
DROP TABLE sessionTask IF EXISTS CASCADE;
CREATE CACHED TABLE sessionTask (
  idsessionTask INT GENERATED BY DEFAULT AS IDENTITY,
  startTime DATETIME NULL ,
  endTime DATETIME NULL ,
  elapsedTime VARCHAR(45) NULL ,
  status VARCHAR(45) NULL ,
  value VARCHAR(128) NULL ,
  nbExtract INT NULL ,
  nbLocalOnlineFiles INT NULL ,
  nbLocalOfflineFiles INT NULL ,
  nbDownloadFiles INT NULL ,
  bandwidth FLOAT NULL ,
  nbFilesMoved INT NULL ,
  nbFilesCopied INT NULL ,
  taskType VARCHAR(45) NULL ,
  nbreMetaProcess INT NULL ,
  PRIMARY KEY (idsessionTask) )



-- -----------------------------------------------------
-- Table session
-- -----------------------------------------------------
DROP TABLE session IF EXISTS CASCADE;
CREATE CACHED TABLE session (
  idsession BIGINT NOT NULL ,
  ref_idupdateBank INT NOT NULL ,
  href VARCHAR(256) NULL ,
  parse VARCHAR(45) NULL ,
  status BOOLEAN NULL ,
  startTime DATETIME NULL ,
  endTime DATETIME NULL ,
  elapsedTime VARCHAR(45) NULL ,
  logfile VARCHAR(128) NULL ,
  insert_hack INT NULL,
  PRIMARY KEY (idsession) ,
  CONSTRAINT fk_session_updateBank1
    FOREIGN KEY (ref_idupdateBank )
    REFERENCES updateBank (idupdateBank )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)

CREATE INDEX fk_session_updateBank1 ON session (ref_idupdateBank ASC) ;
	

-- -----------------------------------------------------
-- Table metaprocess
-- -----------------------------------------------------
DROP TABLE metaprocess IF EXISTS CASCADE;
CREATE CACHED TABLE metaprocess (
  idmetaprocess VARCHAR(45) NOT NULL,
  name VARCHAR(45) NULL ,
  startTime DATETIME NULL ,
  endTime DATETIME NULL ,
  elapsedTime VARCHAR(45) NULL ,
  status VARCHAR(45) NULL ,
  logfile VARCHAR(256) NULL ,
  block VARCHAR(45) NULL ,
  ref_idsessionTask INT NOT NULL ,
  insert_hack INT NULL,
  PRIMARY KEY (idmetaprocess) ,
  CONSTRAINT fk_metaprocess_sessionTask1
    FOREIGN KEY (ref_idsessionTask )
    REFERENCES sessionTask (idsessionTask )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)


CREATE INDEX fk_metaprocess_sessionTask1 ON metaprocess (ref_idsessionTask ASC) ;


-- -----------------------------------------------------
-- Table process
-- -----------------------------------------------------
DROP TABLE process IF EXISTS CASCADE;
CREATE CACHED TABLE process (
  idprocess INT GENERATED BY DEFAULT AS IDENTITY,
  name VARCHAR(45) NULL ,
  keyname VARCHAR(45) NULL ,
  exe VARCHAR(128) NULL ,
  args VARCHAR(128) NULL ,
  desc VARCHAR(512) NULL ,
  type VARCHAR(45) NULL ,
  startTime DATETIME NULL ,
  endTime DATETIME NULL ,
  elapsedTime VARCHAR(45) NULL ,
  biomaj_error BOOLEAN NULL ,
  timestamp BIGINT NULL ,
  value VARCHAR(45) NULL ,
  ref_idmetaprocess VARCHAR(45) NOT NULL ,
  PRIMARY KEY (idprocess) ,
  CONSTRAINT fk_process_metaprocess1
    FOREIGN KEY (ref_idmetaprocess )
    REFERENCES metaprocess (idmetaprocess )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)


CREATE INDEX fk_process_metaprocess1 ON process (ref_idmetaprocess ASC) ;


-- -----------------------------------------------------
-- Table file
-- -----------------------------------------------------
DROP TABLE file IF EXISTS CASCADE;
CREATE CACHED TABLE file (
  idfile INT GENERATED BY DEFAULT AS IDENTITY ,
  location VARCHAR(128) NULL ,
  size BIGINT NULL ,
  time BIGINT NULL ,
  link BOOLEAN NULL ,
  _extract BOOLEAN NULL ,
  volatile BOOLEAN NULL ,
  refHash VARCHAR(45) NULL ,
  fileType VARCHAR(45) NULL ,
  ref_idprocess INT NULL ,
  PRIMARY KEY (idfile) ,
  CONSTRAINT fk_file_process1
    FOREIGN KEY (ref_idprocess )
    REFERENCES process (idprocess )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)

CREATE INDEX fk_file_process1 ON file (ref_idprocess ASC) ;


-- -----------------------------------------------------
-- Table productionDirectory
-- -----------------------------------------------------
DROP TABLE productionDirectory IF EXISTS CASCADE;
CREATE CACHED TABLE productionDirectory (
  idproductionDirectory INT GENERATED BY DEFAULT AS IDENTITY,
  remove DATETIME NULL ,
  creation DATETIME NULL ,
  size VARCHAR(45) NULL ,
  state VARCHAR(45) NULL ,
  session BIGINT NULL ,
  path VARCHAR(256) NULL ,
  ref_idbank INT NOT NULL ,
  PRIMARY KEY (idproductionDirectory) ,
  CONSTRAINT fk_productionDirectory_bank1
    FOREIGN KEY (ref_idbank )
    REFERENCES bank (idbank )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)


CREATE INDEX fk_productionDirectory_bank1 ON productionDirectory (ref_idbank ASC) ;


-- -----------------------------------------------------
-- Table message
-- -----------------------------------------------------
DROP TABLE message IF EXISTS CASCADE;
CREATE CACHED TABLE message (
  idmessage INT GENERATED BY DEFAULT AS IDENTITY,
  message VARCHAR(512) NULL ,
  type VARCHAR(45) NULL ,
  PRIMARY KEY (idmessage) )



-- -----------------------------------------------------
-- Table session_has_message
-- -----------------------------------------------------
DROP TABLE session_has_message IF EXISTS CASCADE;
CREATE CACHED TABLE session_has_message (
  idsession_has_message INT GENERATED BY DEFAULT AS IDENTITY,
  ref_idsession BIGINT NOT NULL ,
  ref_idmessage INT NOT NULL ,
  PRIMARY KEY (idsession_has_message) ,
  CONSTRAINT fk_session_has_message_session1
    FOREIGN KEY (ref_idsession )
    REFERENCES session (idsession )
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT fk_session_has_message_message1
    FOREIGN KEY (ref_idmessage )
    REFERENCES message (idmessage )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)


CREATE INDEX fk_session_has_message_session1 ON session_has_message (ref_idsession ASC) ;

CREATE INDEX fk_session_has_message_message1 ON session_has_message (ref_idmessage ASC) ;


-- -----------------------------------------------------
-- Table sessionTask_has_message
-- -----------------------------------------------------
DROP TABLE sessionTask_has_message IF EXISTS CASCADE;
CREATE CACHED TABLE sessionTask_has_message (
  idsessionTask_has_message INT GENERATED BY DEFAULT AS IDENTITY,
  ref_idsessionTask INT NOT NULL ,
  ref_idmessage INT NOT NULL ,
  PRIMARY KEY (idsessionTask_has_message) ,
  CONSTRAINT fk_sessionTask_has_message_sessionTask1
    FOREIGN KEY (ref_idsessionTask )
    REFERENCES sessionTask (idsessionTask )
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT fk_sessionTask_has_message_message1
    FOREIGN KEY (ref_idmessage )
    REFERENCES message (idmessage )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)


CREATE INDEX fk_sessionTask_has_message_sessionTask1 ON sessionTask_has_message (ref_idsessionTask ASC) ;

CREATE INDEX fk_sessionTask_has_message_message1 ON sessionTask_has_message (ref_idmessage ASC) ;


-- -----------------------------------------------------
-- Table metaprocess_has_message
-- -----------------------------------------------------
DROP TABLE metaprocess_has_message IF EXISTS CASCADE;
CREATE CACHED TABLE metaprocess_has_message (
  idmetaprocess_has_message INT GENERATED BY DEFAULT AS IDENTITY,
  ref_idmetaprocess VARCHAR(45) NOT NULL ,
  ref_idmessage INT NOT NULL ,
  PRIMARY KEY (idmetaprocess_has_message) ,
  CONSTRAINT fk_metaprocess_has_message_metaprocess1
    FOREIGN KEY (ref_idmetaprocess )
    REFERENCES metaprocess (idmetaprocess )
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT fk_metaprocess_has_message_message1
    FOREIGN KEY (ref_idmessage )
    REFERENCES message (idmessage )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)


CREATE INDEX fk_metaprocess_has_message_metaprocess1 ON metaprocess_has_message (ref_idmetaprocess ASC) ;

CREATE INDEX fk_metaprocess_has_message_message1 ON metaprocess_has_message (ref_idmessage ASC) ;


-- -----------------------------------------------------
-- Table process_has_message
-- -----------------------------------------------------
DROP TABLE process_has_message IF EXISTS CASCADE;
CREATE CACHED TABLE process_has_message (
  idprocess_has_message INT GENERATED BY DEFAULT AS IDENTITY,
  ref_idprocess INT NOT NULL ,
  ref_idmessage INT NOT NULL ,
  PRIMARY KEY (idprocess_has_message) ,
  CONSTRAINT fk_process_has_message_process1
    FOREIGN KEY (ref_idprocess )
    REFERENCES process (idprocess )
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT fk_process_has_message_message1
    FOREIGN KEY (ref_idmessage )
    REFERENCES message (idmessage )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)


CREATE INDEX fk_process_has_message_process1 ON process_has_message (ref_idprocess ASC) ;

CREATE INDEX fk_process_has_message_message1 ON process_has_message (ref_idmessage ASC) ;



-- -----------------------------------------------------
-- Table session_has_sessionTask
-- -----------------------------------------------------
DROP TABLE IF EXISTS session_has_sessionTask;
CREATE CACHED TABLE session_has_sessionTask (
  idsession_has_sessionTask INT GENERATED BY DEFAULT AS IDENTITY,
  ref_idsession BIGINT NOT NULL ,
  ref_idsessionTask INT NOT NULL ,
  PRIMARY KEY (idsession_has_sessionTask) ,
  CONSTRAINT fk_session_has_sessionTask_session1
    FOREIGN KEY (ref_idsession )
    REFERENCES session (idsession )
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT fk_session_has_sessionTask_sessionTask1
    FOREIGN KEY (ref_idsessionTask )
    REFERENCES sessionTask (idsessionTask )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)

CREATE INDEX fk_session_has_sessionTask_session1 ON session_has_sessionTask (ref_idsession ASC) ;

CREATE INDEX fk_session_has_sessionTask_sessionTask1 ON session_has_sessionTask (ref_idsessionTask ASC) ;



-- -----------------------------------------------------
-- Table sessionTask_has_file
-- -----------------------------------------------------
DROP TABLE IF EXISTS sessionTask_has_file ;

CREATE CACHED TABLE sessionTask_has_file (
  idsessionTask_has_file INT GENERATED BY DEFAULT AS IDENTITY,
  ref_idsessionTask INT NOT NULL ,
  ref_idfile INT NOT NULL ,
  PRIMARY KEY (idsessionTask_has_file) ,
  CONSTRAINT fk_sessionTask_has_file_sessionTask1
    FOREIGN KEY (ref_idsessionTask )
    REFERENCES sessionTask (idsessionTask )
    ON DELETE CASCADE
    ON UPDATE NO ACTION,
  CONSTRAINT fk_sessionTask_has_file_file1
    FOREIGN KEY (ref_idfile )
    REFERENCES file (idfile )
    ON DELETE CASCADE
    ON UPDATE NO ACTION)

CREATE INDEX fk_sessionTask_has_file_sessionTask1 ON sessionTask_has_file (ref_idsessionTask ASC) ;

CREATE INDEX fk_sessionTask_has_file_file1 ON sessionTask_has_file (ref_idfile ASC) ;

