/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_INVESTIGATOR_DBUS_H__
#define __BKL_INVESTIGATOR_DBUS_H__

#include <glib-object.h>


G_BEGIN_DECLS

#define BKL_TYPE_INVESTIGATOR_DBUS                                      \
   (bkl_investigator_dbus_get_type())
#define BKL_INVESTIGATOR_DBUS(obj)                                      \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_INVESTIGATOR_DBUS,             \
                                BklInvestigatorDBus))
#define BKL_INVESTIGATOR_DBUS_CLASS(klass)                              \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_INVESTIGATOR_DBUS,                \
                             BklInvestigatorDBusClass))
#define IS_BKL_INVESTIGATOR_DBUS(obj)                                   \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_INVESTIGATOR_DBUS))
#define IS_BKL_INVESTIGATOR_DBUS_CLASS(klass)                           \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_INVESTIGATOR_DBUS))
#define BKL_INVESTIGATOR_DBUS_GET_CLASS(obj)                            \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_INVESTIGATOR_DBUS,              \
                               BklInvestigatorDBusClass))

typedef struct _BklInvestigatorDBusPrivate BklInvestigatorDBusPrivate;
typedef struct _BklInvestigatorDBus      BklInvestigatorDBus;
typedef struct _BklInvestigatorDBusClass BklInvestigatorDBusClass;

struct _BklInvestigatorDBus
{
    GObject parent;

    BklInvestigatorDBusPrivate *priv;
};

struct _BklInvestigatorDBusClass
{
    GObjectClass parent_class;
};

GType bkl_investigator_dbus_get_type (void) G_GNUC_CONST;

BklInvestigatorDBus *bkl_investigator_dbus_new (void);
void bkl_investigator_dbus_processing (BklInvestigatorDBus *dbus,
                                       const char          *source,
                                       const char          *uri);
void bkl_investigator_dbus_completed (BklInvestigatorDBus *dbus,
                                      const char          *source,
                                      const char          *uri,
                                      GHashTable          *metadata);

G_END_DECLS

#endif /* __BKL_INVESTIGATOR_DBUS_H__ */
