/*
 * Copyright (c) 2005 Jeremy Erickson
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "quizact.h"
#include "verse.h"
#include "qt_types.h"
#include <qlabel.h>
#include <qpushbutton.h>
using bmemcore::Verse;
using bmemcore::CorrectionWord;

namespace bmemui
{

QuizAct::QuizAct(Verse& verse, QWidget* parent, const char* name)
:QuizUI(parent, name), mVerse(verse)
{}

void QuizAct::mCheckButton_clicked()
{
    if (mVerse.checkText(mVerseEdit->text()))
    {
        mResultLabel->setText(tr("Correct."));
    }
    else
    {
        mResultLabel->setText(tr("Incorrect."));
    }
}

void QuizAct::mCorrectButton_clicked()
{
    std::list<bmemcore::CorrectionWord> corrections = mVerse.correctText(
            mVerseEdit->text());
    std::list<bmemcore::CorrectionWord>::iterator it = corrections.begin();
    QString html;
    while (it != corrections.end())
    {
        switch (it->state)
        {
            case CorrectionWord::WORD_STATE_CORRECT:
                html += it->word;
                break;
            case CorrectionWord::WORD_STATE_MISSING:
                html += "<b>";
                html += it->word;
                html += "</b>";
                break;
            case CorrectionWord::WORD_STATE_WRONG:
                html += "<font color=red>";
                html += it->word;
                html += "</font>";
                break;
        }
        html += " ";
        ++it;
    }
    mVerseEdit->setText(html);
    mVerseEdit->setReadOnly(true);
    mCorrectButton->setEnabled(false);
    mCheckButton_clicked();
}

void QuizAct::mClearButton_clicked()
{
    mVerseEdit->setText("");
    mVerseEdit->setReadOnly(false);
    mCorrectButton->setEnabled(true);
    mResultLabel->setText("");
}

}

