/*
 * Copyright (c) 2005, 2006 Jeremy Erickson
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef MAINACT_H
#define MAINACT_H

#include "MainUI.h"
#include "watchermainact.h"
#include "versecollection.h"
#include "verseact.h"
#include "qt_types.h"
#include <qevent.h>
#include <qstringlist.h>
#include <list>
#include <map>
//#include <qassistantclient.h>

namespace bmemcore
{
class Verse;
class SearchFilter;
class FilterSearchQuery;
class BiblePlugin;
}
class QStringList;
//class QAssistantClient;

namespace bmemui
{
class WatcherMainAct;
class MainAct: public MainUI
{
    Q_OBJECT
public:
    friend class WatcherMainAct;
    //friend class SearchAct;
    MainAct(QWidget *parent = 0, const char *name = 0);
    virtual bool eventFilter(QObject* watched, QEvent* e);
    virtual ~MainAct();
public slots:
    virtual void mToggleButton_clicked();
    virtual void fileExitAction_activated();
    virtual void mAddButton_clicked();
    virtual void helpAboutAction_activated();
    virtual void mVerseListBox_selectionChanged();
    virtual void helpContentsAction_activated();
    virtual void mOpenButton_clicked();
    virtual void fileNewAction_activated();
    virtual void mRemoveButton_clicked();
    virtual void mFilterComboBox_activated(int);
    virtual void mCategoryListBox_selectionChanged();
    virtual void fileSaveAsAction_activated();
    virtual void fileSaveAction_activated();
    virtual void fileOpenAction_activated();
    virtual void mRemoveCategoryButton_clicked();
    virtual void mRenameCategoryButton_clicked();
    virtual void mAddCategoryButton_clicked();
    virtual void mSearchButton_clicked();
    virtual void preferencesSettingsAction_activated();
    virtual void mVerseListBox_doubleClicked(BQListBoxItem*);
    virtual void editMenu_aboutToShow();
protected:
    QWidget* currWidget;
    bmemcore::VerseCollection *mVerses;
    std::list<WatcherMainAct*> mWatchers;
    std::map<BQListBoxItem*, bmemcore::Verse*> mListItemMap;
//    bmemcore::FilterSearchQuery *mSearchQuery;
    QString mSearchQuery;
    bmemcore::SearchFilter *mSearchFilter;
    bmemcore::BiblePlugin *mPlugin;
    QString mCurrentFileName;
    QString mFileFilters;
    //QAssistantClient mAssistantClient;
    void setCurrentFileName(const QString&);
    bool promptSave();
    void closeEvent(QCloseEvent*);
    bool save();
    bool saveAs();
    void openFile(const QString&);
    inline void openVerse(bmemcore::Verse *verse, VerseAct::PageType);
private:
    void associateListItem(BQListBoxItem*, bmemcore::Verse*);
    void dissociateListItem(BQListBoxItem*);
    void addWatcher(WatcherMainAct*);
    void removeWatcher(WatcherMainAct*);
//    void setSearchQuery(bmemcore::FilterSearchQuery*);
    void setSearchQuery(const QString&);
};

}

#endif
