#!/bin/sh
#
# Copyright (c) 2009, Sendmail, Inc. and its suppliers.
# 	All rights reserved.
#
# $Id: allow-to-ilist.sh,v 1.2 2009/03/27 19:23:55 msk Exp $
#
# Script to generate batv-filter's "internal hosts" list based on the contents
# of its "allow" list.

# setup
ALLOW=/etc/mail/batv/allowlist
INTERNAL=/etc/mail/batv/internal-hosts
defaults="127.0.0.1 localhost"

HOSTNAME=`hostname`
DOMAIN=`echo $HOSTNAME | sed 's/^[a-z0-9-]*\.//'`

# basic tests
if [ ! -f $ALLOW ]
then
	echo $0: $ALLOW not found
	exit 1
fi

if [ ! -f $INTERNAL ]
then
	echo $0: $INTERNAL not found
	exit 1
fi

# back up the internal list
cp -p $INTERNAL ${INTERNAL}.old

# copy comments
grep '^#' ${INTERNAL}.old > $INTERNAL

# extract old entries
grep -v '^#' ${INTERNAL}.old > ${INTERNAL}.new

# add defaults
for def in $defaults
do
	echo $def >> ${INTERNAL}.new
done

# add self and domain
echo $HOSTNAME >> ${INTERNAL}.new
if [ $HOSTNAME != $DOMAIN ]
then
	echo .${DOMAIN} >> ${INTERNAL}.new
fi

# process each allow-list entry
for addr in `grep -v '^#' ${ALLOW} | sort -u`
do
	# add the domain
	domain=`echo $addr | sed 's/^.*@//'`
	echo .${domain} >> ${INTERNAL}.new

	# add its MXes
	for mx in `host -t mx $domain | awk '{print $NF}'`
	do
		for a in `host -t a $mx | awk '{print $NF}'`
		do
			echo $a >> ${INTERNAL}.new
		done
	done
done

# append to main output
sort -u ${INTERNAL}.new >> $INTERNAL

# tidy up
rm -f ${INTERNAL}.new

# done
exit 0
