# Copyright (C) 2002-2003 Hewlett Packard
# Copyright (C) 2005 Jay Beale
# Copyright (C) 2005 Charlie Long, Delphi Research
# Licensed under the GNU General Public License

require Bastille::API;
import Bastille::API;

$GLOBAL_TEST{'DNS'}{'namedoff'} = 
    sub { 
	# see if the named service is scheduled to run
	my $isServiceOff = &B_is_service_off('named');
	if(defined $isServiceOff && $isServiceOff == 0) {
	    # if it is running ask the question
	    return $ASKQ;
	}
	else {
	    # otherwise don't ask the question
	    return $SKIPQ;
	}
    };

$GLOBAL_TEST{'DNS'}{'chrootbind'} =
    sub {

	my $distro = &GetDistro;

	if ($distro =~ /^RHEL/ or $distro =~ /^RHFC/ ) {
	    # Chrooting BIND is easy on RHEL -- just set the
	    # ROOTDIR variable in /etc/sysconfig/named.	    
	    if ( &B_match_line(&getGlobal('FILE','sysconfig_named'),'^ROOTDIR\s*=\s*[^\s]+\s*$') ) {
		return $SKIPQ;
	    }
	}
	elsif ($distro =~ /^SESLES/ or $distro =~ /^SE9/ ) {
	    # Chrooting BIND is easy on SLES and later SUSE versions -- just set the NAMED_RUN_CHROOTED to "yes" in
	    # /etc/sysconfig/named
	    if ( &B_match_line(&getGlobal('FILE','sysconfig_named'),'^\s*NAMED_RUN_CHROOTED=\s*yes\s*$') ) {
		return $SKIPQ;
	    }
	}
	elsif ($distro =~ /^MN/) {
	    # As of Mandrake 10.1, there is init script support via the ROOTDIR variable, but they don't
	    # yet build their own chroot.  So we can't check this way.
	}	
	# Check to see if named is activated -- if it isn't, just skip the question.
	elsif (&B_is_service_off('named')) {
	    return $SKIPQ;
	}
	#
	# If named is activated and the above items didn't find it configured for chroot, look for a chrooted BIND process.
	# 

        #Get the named pid;
        my @procfile;
        my @process = `ps aux`;

	# BIND doesn't need to be chrooted if it's missing.
	unless ( -e &getGlobal('FILE','named') ) {
	    return $SKIPQ;
	}
	
        foreach my $process (@process) {
	    my $pid;

	    # Check if we're looking at a named process
            unless ($process =~ /\bnamed\b/)
            {
		next;
	    }

	    # If we are, check its root.
	    my (@fields) = split(/\s+/, $process);
	    $pid = $fields[1];

	    if (defined $pid) {
		# Parse the /proc/<pid>/root link.
		@procfile = split(/\s+/, `ls -ld /proc/$pid/root`);
		if ($procfile[9] eq '->')
		{
		    unless (($procfile[10]) ne '/' and ($procfile[10] ne ""))
		    {
			# We're not chrooted.
			return $ASKQ;
		    }
		}
	    }
	}
	return $SKIPQ;
    };
1;
