#include "../include/soundmanager.h"

using namespace Balder;

SoundManager::SoundManager()
{
    Mix_OpenAudio(44100,MIX_DEFAULT_FORMAT,2,512);
    PlayMusic("menu");
    double volume = ConfigManager::GetDoubleValue("Sound", "fxvolume");
    Mix_Volume(-1, (int)(MIX_MAX_VOLUME * volume));
}
SoundManager::~SoundManager()
{
    StopMusic();
    Mix_CloseAudio();
}

bool SoundManager::LoadSoundType(const char* name, const char* file)
{
	Mix_Chunk *sample = Mix_LoadWAV(file);
    if (0 == sample) { return false;}
	sound_registry[name] = sample;
	return true;
}

void SoundManager::PlaySound(const char *name)
{
    if (ConfigManager::GetIntValue("Sound", "sound")) {
    	Mix_Chunk *sample = sound_registry[name];
	    if (sample){
		    Mix_PlayChannel(-1, sample, 0);
        }
	}
}

void SoundManager::PlayMusic(std::string name)
{
    StopMusic();

    if (name != "NONE" || name != "None" || name != "none") {
        std::string music_file = "music/";
        music_file += name;
        music_file += ".ogg";
        if (ConfigManager::GetIntValue("Sound", "music")) {
            music = Mix_LoadMUS(music_file.c_str());
            if (music){
    	        Mix_PlayMusic(music,1);
                double volume = ConfigManager::GetDoubleValue("Sound", "musicvolume");
    	        Mix_VolumeMusic(int(SDL_MIX_MAXVOLUME*volume));
            }
        }
    }
}

void SoundManager::StopMusic()
{
    if (Mix_PlayingMusic()) {
    	if (music){
	        Mix_FreeMusic(music);
	        music = 0;
	    }
    }
}
