<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    setup-orgs.php                                          */
/* Author:      Paul Waite                                              */
/* Description: Organisation setup page                                 */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("maintainer-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Organisations", "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

$maint = new maintainer("Organisations", "ax_organisation");
$maint->set_allowed_groups("Admin");
$maint->setalign("center");
$maint->joined_table("Contact Details", "ax_contactinfo", "contactinfo_id");
$maint->set_hiddenfields("contactinfo_id");

$RESPONSE->plugin("MAIN_CONTENT", $maint->render());

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>