<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-site-metadata.php                                  */
/* Author:      Paul Waite                                              */
/* Description: A page for maintaining the website metadata, allowing   */
/*              you to determine which elements to include, and once    */
/*              included, determine how they are to be used.            */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$maint_formname = "languages";
$HEADING = "LANGUAGE MANAGEMENT";
$RESPONSE->page($HEADING, "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");
include_once("recmaint-defs.php");

//debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);
//debug_output(DBG_O_LOG);

// ------------------------------------------------------------------
// AUTHORISATION

// Only Editors and Admin allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// ------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "view";

// ##################################################################
// POST PROCESSING

// SAVE LANGUAGES DATA..
if (isset($_recmaintpost_form)
        && $_recmaintpost_form == $maint_formname) {
  // Element saves..
  if (isset($_recmaintpost_data) && $_recmaintpost_data != "") {
    $recs = explode(RECORD_DELIM, $_recmaintpost_data);
    $langfields = explode(",", $_recmaintpost_flds);
    foreach ($recs as $langrec) {
      $langvalues = explode(FIELD_DELIM, $langrec);
      $langid = array_shift($langvalues);
      // Cater for new creations..
      if (strstr($langid, "NEW_")) {
        $savedid = $langid;
        $langid = get_next_sequencevalue("seq_lang_id", "ax_language", "lang_id");
        $in = new dbinsert("ax_language");
        $in->set("lang_id", $langid);
        $in->set("lang_desc", "");
        $in->set("char_encoding", "");
        $in->execute();
        // Fix up potential re-ordering id..
        if (isset($_recmaintpost_order)) {
          $_recmaintpost_order = str_replace($savedid, $langid, $_recmaintpost_order);
        }
      }
      // Update the language data..
      $um = new dbupdate("ax_language");
      $um->where("lang_id=$langid");
      $pos = 0;
      foreach ($langfields as $langfield) {
        $langval = $langvalues[$pos];
        $um->set($langfield, $langval);
        $pos += 1;
      }
      $um->execute();
    } // foreach saved record
  }

  // Check/save ordering..
  if (isset($_recmaintpost_order) && $_recmaintpost_order != "") {
    $ord = 1;
    $idlist = explode(FIELD_DELIM, $_recmaintpost_order);
    foreach ($idlist as $langid) {
      $upd = new dbupdate("ax_language");
      $upd->where("lang_id=$langid");
      $upd->set("display_order", $ord);
      $upd->execute();
      $ord += 1;
    }
  }
}

// ##################################################################
// FORM ELEMENTS

// Width of large form elements..
$ewidth = "300px";
$cwidth = "150px";
$pwidth = "90px";

// ------------------------------------------------------------------
// LANGUAGES MAINTAINER

// KEYFIELD and RECORD MAINTAINER
// Declared here so we can create the maintainer and register buttons
// before they are used in the form.
//
// This is the keyfield listbox which controls the maintainance
// process. It lists all records being maintained..
$lang_listbox = new form_combofield("key_lang");
$lang_listbox->setclass("axlistbox");
$lang_listbox->setstyle("width:$ewidth;");
$lang_listbox->size = 12;

// Make a new record maintainer..
$maintainer = new recmaintainer($maint_formname, $lang_listbox);

// BUTTONS..
$bup    = new form_imagebutton("_up",     "", "", "$LIBDIR/img/_up.gif",     "Move up",         57, 15);
$bdown  = new form_imagebutton("_down",   "", "", "$LIBDIR/img/_down.gif",   "Move down",       57, 15);
$badd   = new form_imagebutton("_add",    "", "", "$LIBDIR/img/_add.gif",    "Add language",    57, 15);
$bdel   = new form_imagebutton("_delete", "", "", "$LIBDIR/img/_delete.gif", "Remove language", 57, 15);
$bsav   = new form_imagebutton("_save",   "", "", "$LIBDIR/img/_save.gif",   "Save changes",    57, 15 );
$breset = new form_imagebutton("_reset",  "", "", "$LIBDIR/img/_reset.gif",  "Reset",           57, 15);

$maintainer->register_button("up" ,   $bup);
$maintainer->register_button("down",  $bdown);
$maintainer->register_button("add",   $badd);
$maintainer->register_button("del",   $bdel);
$maintainer->register_button("reset", $breset);
$maintainer->register_button("save",  $bsav);

$Ted = new table("langs");
$Ted->setpadding(2);

// ..................................................................
// Heading..
$Ted->tr("axhdg");
$Ted->td("<b>LANGUAGES</b>", "axhdg");
$Ted->td_colspan(2);

// ..................................................................
// Continue defining main listbox..
$q  = "SELECT *";
$q .= "  FROM ax_language";
$q .= " ORDER BY display_order";
$langs = dbrecordset($q);
$langcount = $langs->rowcount;
if ($langcount > 0) {
  do {
    // Populate listbox..
    $_lang_id       = $langs->field("lang_id");
    $_lang_desc     = $langs->field("lang_desc");
    $_char_encoding = $langs->field("char_encoding");
    $_direction     = $langs->field("direction");
    $_is_default    = $langs->istrue("is_default");
    $_enabled       = $langs->istrue("enabled");
    $label = $_lang_desc;
    if ($_char_encoding != "") {
      $label .= " [$_char_encoding]";
    }
    if ($_is_default) {
      $label .= " *";
    }
    $lang_listbox->additem($_lang_id, $label);

    // Populate maintainer data. The maintainer add_record method
    // requires an associative array keyed on listbox key id..
    $rec = array(
            "lang_desc"     => $_lang_desc,
            "char_encoding" => $_char_encoding,
            "direction"     => $_direction,
            "is_default"    => $_is_default ? "t" : "f",
            "enabled"       => $_enabled ? "t" : "f"
            );
    $maintainer->add_record($_lang_id, $rec);

    // If this is the language being edited, make sure
    // that it gets focussed..
    if (isset($lang_id) && $lang_id == $_lang_id) {
      $maintainer->initial_record($_lang_id);
    }
  } while ($langs->get_next());

  // Now set the defaults for each of the fields. These are
  // necessary for when a new record is created..
  $defaults = array(
            "lang_desc" => "",
            "char_encoding" => "",
            "direction" => "LTR",
            "is_default" => "f",
            "enabled" => "t"
            );
  $maintainer->add_defaults($defaults);
}


// ------------------------------------------------------------------
// CONTROL BUTTONS
$buttons = $bsav->render()   . "<br>"
         . $badd->render()   . "<br>"
         . $bdel->render()   . "<br>"
         . $breset->render() . "<br>";
if ($langcount > 1) {
  $buttons .= $bup->render()    . "<br>"
            . $bdown->render()  . "<br>";
}
$CONTROL_BUTTONS = $buttons;

// ..................................................................
// MAINTAINER LISTBOX, and FORM FIELDS
$Ted->tr("axbgdark");
$Ted->td( $CONTROL_BUTTONS );
$Ted->td_alignment("right", "top");
$Ted->td( $lang_listbox->render() );
$Ted->td_alignment("", "top");

// Information..
$Ted->tr("axbgdark");
$Ted->td( "&nbsp;" );
$Ted->td(
  "Asterisks (*) indicate language(s) will be selected by default",
  "axfg"
  );
$Ted->td_css("font-style:italic;font-size:80%");
$Ted->td_alignment("", "top");
// ..................................................................
$Ted->tr("axhdg");
$Ted->td("<b>LANGUAGE PROPERTIES</b>", "axhdg");
$Ted->td_colspan(2);

// ..................................................................
$Fld = new form_textfield("lang_desc");
$Fld->setstyle("width:$ewidth;");
$Fld->setclass("axtxtbox");
$maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Description:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_textfield("char_encoding");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axtxtbox");
$maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Character encoding code:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_combofield("direction");
$Fld->additem("LTR", "Left to right");
$Fld->additem("RTL", "Right to left");
$Fld->setstyle("width:$cwidth;");
$Fld->setclass("axcombo");
$maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Direction:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_checkbox("is_default");
$Fld->setclass("axchkbox");
$maintainer->register_field($Fld);
$Ted->tr("axbgdark");
$Ted->td( "Is default:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
$Fld = new form_checkbox("enabled");
$Fld->setclass("axchkbox");
$maintainer->register_field($Fld);
$Ted->tr("axbglite");
$Ted->td( "Enabled:", "axfg" );
$Ted->td( $Fld->render() );

// ..................................................................
// Render the whole form..
$Ted->tr("axtitle");
$Ted->td("&nbsp;", "axtitle");
$Ted->td_colspan(2);

$Ted->set_width_profile("30%,70%");
$LANGUAGES .= $Ted->render();

// Render the maintainer. This adds the Javascript data structures
// and renders the hidden fields for submitting changed field data..
$LANGUAGES .= $maintainer->render();

// ------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// ------------------------------------------------------------------
// mode field
$hid = new form_hiddenfield("mode", $mode);
$MODE_HIDDEN = $hid->render();

// ##################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form class="axform" name="languages" method="post">
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width="100%" align=center>
    <tr class="axtitle">
      <td align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center class=axerror><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td class="axyl_rowstripe_dark" width="47%" valign="top"><!--LANGUAGES--></td>
    </tr>
    <tr class="axfoot">
      <td>&nbsp;</td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// ##################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("ERROR_MSG",         $ERROR_MSG);
$RESPONSE->plugin("LANGUAGES",         $LANGUAGES);
$RESPONSE->plugin("CONTROL_BUTTONS",   $CONTROL_BUTTONS);

// ------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>