<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    constants.php                                           */
/* Author:      Paul Waite                                              */
/* Description: Useful contants for usage within Axyl.                  */
/*                                                                      */
/* ******************************************************************** */
/** @package utils */

// Bytes
/** Kilobytes */
define("KILOBYTE",           1024);
/** Megabytes */
define("MEGABYTE",        1048576);
/** Gigabytes */
define("GIGABYTE",     1073741824);

// Time
/** Ten years - used as 'forever' */
define("SECS_10_YEARS", 315360000);
/** One year */
define("SECS_1_YEAR",    31536000);
/** One month */
define("SECS_1_MONTH",    2592000);
/** One week */
define("SECS_1_WEEK",      604800);
/** One day */
define("SECS_1_DAY",        86400);
/** 12 hours */
define("SECS_12_HOURS",     43200);
/** 8 hours */
define("SECS_8_HOURS",      28800);
/** 4 hours */
define("SECS_4_HOURS",      14400);
/** 1 hour */
define("SECS_1_HOUR",        3600);
/** 20 minutes */
define("SECS_20_MINS",       1200);

/** Field delimiter used in record structures */
define("FIELD_DELIM", "^_^");
/** Record delimiter used in record lists */
define("RECORD_DELIM", "~_~");

// -------------------------------------------------------------------------
?>