#!/bin/bash

# Sanity check..
if [ ! -d debian ] ; then
  echo "you are not in a debian packaging directory!"
fi

# Allow user override
if [ "$1" != "" ]
then
  USER=$1
fi

# Build debian package..
PACKAGE=`head -n 1 debian/control | cut -f2 -d' '`
PACKAGE_DOC=${PACKAGE}-doc
USER=${1:-"${DEBFULLNAME} <${DEBEMAIL}>"}
if [ "$USER" = "" -o "$USER" = " " -o "$USER" = " <>" ] ; then
  USER=`dpkg-parsechangelog | sed -n 's/^Maintainer: //p'`
fi
VERSION=`head -n 1 debian/changelog | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`

# CVS repositories..
HTMLAREA_CVSROOT=":pserver:anonymous@cvs.sourceforge.net:/cvsroot/itools-htmlarea"
PACKAGE_CVSROOT=catalyst/codeforge/php/${PACKAGE}

# If not present, always build ChangeLog, else ask..
if [ ! -f ChangeLog ]; then
  ANS=y
else
  echo -n "refresh ChangeLog? (y/n) [n]: "
  read ANS
fi
if [ "$ANS" = "y" -o "$ANS" = "Y" ]
then
  echo "generating ChangeLog.."
  cvs2cl >/dev/null 2>&1
fi

# Update the Axyl version into the axyl.version file..
echo "re-writing the version file with ${VERSION}"
echo $VERSION > etc/${PACKAGE}/${PACKAGE}.version

echo "constructing package to build.."
HOMEDIR=`pwd`
cd ..
[ ! -d debian-builds ] && mkdir debian-builds
[ ! -d debian-builds/${PACKAGE} ] && mkdir debian-builds/${PACKAGE}
cd debian-builds/${PACKAGE}
WRKDIR="${PACKAGE}-${VERSION}"
sudo rm -rf $WRKDIR
cp -a $HOMEDIR/ $WRKDIR
cd $WRKDIR
# Cleanse of unwanted stuff..
find . -depth -type d -name "CVS" -exec rm -rf {} \;
find . -name ".cvsignore" -exec rm -f {} \;
find . -name ".#*" -exec rm -f {} \;
find . -name "*.log" -exec rm -f {} \;
find . -name "*.bak" -exec rm -f {} \;
find . -name "diffs.sql" -exec rm -f {} \;

echo "building version ${VERSION} of ${PACKAGE} and ${PACKAGE_DOC} in `pwd`"

cp $HOMEDIR/ChangeLog .

# Fix perms..
RDWR_EXTNS="php jpg gif png wbmp pdm cdm pdf sql xml db js css html"
EXEC_EXTNS="cgi pl sh make-patch"
RDWR_FILES=".htaccess ChangeLog README"
for extn in $RDWR_EXTNS ; do
  find . -iname "*.${extn}" -exec chmod 0664 {} \;
done
for extn in $EXEC_EXTNS ; do
  find . -iname "*.${extn}" -exec chmod 0775 {} \;
done
for file in $RDWR_FILES ; do
  find . -iname "${file}" -exec chmod 0664 {} \;
done
# Special treatment for scripts directory..
find ./scripts -iname "*.php" -exec chmod 775 {} \;

# Ensure we have HTMLarea locally.
if [ -f lib/js/htmlarea/htmlarea.js ]
then
 :
else
  echo "HTMLarea not present in build directory."
  echo "acquiring latest HTMLarea export.."
  cd lib/js
  echo "just hit the [ENTER] key for the CVS password.."
  cvs -d $HTMLAREA_CVSROOT login
  cvs -q -z3 -d $HTMLAREA_CVSROOT export -r HEAD -d htmlarea htmlarea
  cd ../..
fi

# Build it!
dpkg-buildpackage -tc -rsudo -sgpg -m"${USER}" -k"${USER}"

# ENDS
