<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-plugins.inc                                        */
/* Author:      Paul Waite                                              */
/* Description: Axyl plugin content renderers. These functions provide  */
/*              specific Axyl plugin content, as a string for plugging  */
/*              into an Axyl template.                                  */
/*                                                                      */
/* ******************************************************************** */

// Returns the main menu
function main_menu($menutype="treemenu") {
  global $RESPONSE, $LIBDIR, $THEME_MENU;
  $s = "";

  // Determine the menu name. The default is "main" but if we have a
  // microsite to render, then it will be set to the theme-name,
  // which is the same as the micro-site name..
  if ($RESPONSE->microsites_mode == MICROSITES_ENABLED) {
    $MENU_NAME = (isset($THEME_MENU) && $THEME_MENU != "") ? $THEME_MENU : "main";
  }
  else {
    $MENU_NAME = "main";
  }

  // Standard dumb ol' menu for Netscape 4.xx, not multi-level..
  if ($RESPONSE->browser == BROWSER_NETSCAPE) {
    include_once("menu-defs.php");
    $menu = new sitemenu($MENU_NAME, MENU_LEVEL_ALL, "", VERTICAL);
  }
  else {
    // A nice menu for other browsers. Out of the box we have a
    // choice of two: Xmenu and TreeMenu..
    switch ($menutype) {
      case "xmenu":
        include_once("xmenu-defs.php");
        $menu = new Xmenu($MENU_NAME, $RESPONSE);
        //$menu->set_default_images();
        //$menu->set_menu_images(
        //            new img("$LIBDIR/img/_tri.gif", "", "", 5, 10),
        //            new img("$LIBDIR/img/_tridown.gif", "", "", 10, 5)
        //            );
        break;

      default:
      // TreeMenu is a non-javascript multi-level menu, & used only
      // as a left-hand sidebar menu. It's the dfault for the Axyl
      // website which isn't cached, since it's quick to render..
      include_once("treemenu-defs.php");
      $menu = new treemenu($MENU_NAME, $RESPONSE);
    } // switch
  }
  return $menu->render();
} // main menu

// -----------------------------------------------------------------------
// Returns the side menu for the page.
function member_login() {
  global $IMAGESDIR;
  global $RESPONSE;
  // Actual HTML content..
  $s  = "";
  $s .= "<form name=login_fm method=post action=\"$RESPONSE->requested\">";

  $Tlog = new table("auth");
  $Tlog->setwidth(203);
  $Tlog->setpadding(0);
  $Tlog->tbody("font-size:8pt;");
  if ($RESPONSE->ismemberof_group("Guest")) {
    // Button to login..
    $loginbtn = new form_imagebutton("login", "Login", "", "$IMAGESDIR/login.gif", "Click to Login", 203, 21);

    // Username textbox..
    $username_F = new form_textfield("tbxUsername", "NAME");
    $username_F->setcss("loginentry");

    // Password textbox..
    $password_F = new form_passwordfield("tbxPassword", "PASSWD");
    $password_F->setcss("loginentry");

    // Login field labels are images..
    $username_img = new img("$IMAGESDIR/username.gif", "", "", 50, 8);
    $password_img = new img("$IMAGESDIR/password.gif", "", "", 50, 8);

    // This image is 50px wide + 18px padding = 68px..
    $Tlog->tr();
    $Tlog->td( $username_img->render(), "background-color:#AC9D46;padding-left:18px;" );
    $Tlog->td( $username_F->render(), "background-color:#AC9D46" );
    // 132px + 68px + 3px = 203px..
    $Tlog->td_width(132);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    $Tlog->td( "", "bglogin" );
    $Tlog->td_colspan(2);
    $Tlog->td_metrics(200,3);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    // This image is 50px wide + 18px padding = 68px..
    $Tlog->td( $password_img->render(), "background-color:#AC9D46;padding-left:18px;" );
    $Tlog->td( $password_F->render(), "background-color:#AC9D46" );
    // 132px + 68px + 3px = 203px..
    $Tlog->td_width(132);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    $Tlog->td( $loginbtn->render() );
    $Tlog->td_colspan(3);
  }
  else {
    $logoutbtn = new form_imagebutton("logout", "Logout", "", "$IMAGESDIR/logout.gif", "Logout", 203, 21);
    $logout_F = new form_hiddenfield("tbxLogoff", "Logoff");
    $Tlog->tr();
    $Tlog->td( "", "bglogin" );
    $Tlog->td_metrics(200,3);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    $Tlog->td( $RESPONSE->name, "background-color:#AC9D46;color:white;text-align:center;" );
    $Tlog->td_width(200);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    $Tlog->td( $logoutbtn->render() . $logout_F->render() );
    $Tlog->td_colspan(2);
  }
  $s .= $Tlog->render();
  $s .= "</form>";

  // Return HTML..
  return $s;
} // member_login

// -----------------------------------------------------------------------
// Returns the latest news items
function latest_news() {
  global $RESPONSE, $LIBDIR, $CONTEXT;
  static $latest_news;
  // Max. latest stories to display..
  $max_stories = $CONTEXT->configvalue("Max Latest News");
  debugbr("max_stories = $max_stories");
  if (!isset($latest_news)) {
    include_once("story-defs.php");
    if ($RESPONSE->microsite_detected != "") {
      $q  = "SELECT * FROM ax_microsite_story ms, ax_story s, ax_story_location sl, ax_content_location l";
      $q .= " WHERE ms.microsite_name='" . escape_string($RESPONSE->microsite_detected) . "'";
      $q .= "   AND s.story_id=ms.story_id";
      $q .= "   AND s.visible=TRUE";
      $q .= "   AND s.deleted=FALSE";
      $q .= "   AND s.story_date <= CURRENT_TIMESTAMP";
      $q .= "   AND (s.expiry_date IS NULL OR s.expiry_date > CURRENT_TIMESTAMP)";
      $q .= "   AND sl.story_id=s.story_id";
      $q .= "   AND l.location_id=sl.location_id";
      $q .= "   AND l.location_name='Latest News'";
      $q .= " ORDER BY story_date DESC, s.story_id DESC";
    }
    else {
      $q  = "SELECT * FROM ax_story s, ax_story_location sl, ax_content_location l";
      $q .= " WHERE s.visible=TRUE";
      $q .= "   AND s.deleted=FALSE";
      $q .= "   AND s.story_date <= CURRENT_TIMESTAMP";
      $q .= "   AND (s.expiry_date IS NULL OR s.expiry_date > CURRENT_TIMESTAMP)";
      $q .= "   AND sl.story_id=s.story_id";
      $q .= "   AND l.location_id=sl.location_id";
      $q .= "   AND l.location_name='Latest News'";
      if ($RESPONSE->microsites_mode == MICROSITES_ENABLED) {
        $q .= " AND NOT EXISTS (";
        $q .= "  SELECT * FROM ax_microsite_story ms";
        $q .= "   WHERE ms.story_id=s.story_id";
        $q .= " )";
      }
      $q .= " ORDER BY story_date DESC, s.story_id DESC";
    }
    $stories = dbrecordset($q);
    $num_stories = 0;
    $latest_news = "";
    if ($stories->hasdata) {
      $Ts = new table("story_$storyid");
      $Ts->setpadding(3);
      $Ts->setstyle("padding-top:15px;");
      $Ts->setclass("axlatestnews");
      $Ts->setwidth("100%");
      // Title
      $Ts->tr();
      $Ts->td("<span class=\"axtitle\">Latest News</span>", "axlatestnews");
      for ($count = 0; $count < $max_stories; $count++) {
        $storyid = $stories->field("story_id");
        $story = new story($storyid);
        // Story headline & date..
        $storydate = timestamp_to_displaydate(NICE_DATE, $story->story_date_ts);
        $Ts->tr();
        $Ts->td("<span class=\"axhdg\">" . $story->story_headline . "</span><br><span class=\"axsubhdg\">$storydate</span>", "axlatestnews");
        if ($story->story_precis != "") {
          $precis = $story->story_precis;
        }
        else {
          $precis = $story->make_precis(30);
        }
        $href = "/axyl-news.php";
        $href = href_addparm($href, "story_id", $storyid);
        $storylink = new anchor($href, "MORE..");
        $storylink->set_linkover_text("View story");
        $precis .= "&nbsp; " . $storylink->render();
        $Ts->tr();
        $Ts->td($precis, "axlatestnews");
        if (isset($story->story_icon)) {
          $Ts->tr();
          $Ts->td($story->render_story_icon(), "axlatestnews");
          $Ts->td_alignment("right", "bottom");
        }
        $Ts->tr();
        $Ts->td("&nbsp;", "axlatestnews");
        $Ts->td_metrics("", 10);
        // Get next story, or break out if we have no more..
        if ($stories->get_next() === false) {
          break;
        }
      }
      $latest_news .= $Ts->render();
    }
  }
  // Return latest news items as stacked tables..
  if (isset($latest_news)) {
    $s = $latest_news;
  }
  return $s;

} // latest_news

// -----------------------------------------------------------------------
// Featured news item..
function featured_news_item() {
  global $RESPONSE, $LIBDIR, $IMAGESDIR;
  static $feat_news;
  $s = "";
  if (!isset($feat_news)) {
    $Ts = new table("story_$storyid");
    $Ts->setwidth("80%");
    $Ts->setalign("center");
    include_once("story-defs.php");
    if ($RESPONSE->microsite_detected != "") {
      $q  = "SELECT * FROM ax_microsite_story ms, ax_story s, ax_story_location sl, ax_content_location l";
      $q .= " WHERE ms.microsite_name='" . escape_string($RESPONSE->microsite_detected) . "'";
      $q .= "   AND s.story_id=ms.story_id";
      $q .= "   AND s.visible=TRUE";
      $q .= "   AND s.deleted=FALSE";
      $q .= "   AND s.story_date <= CURRENT_TIMESTAMP";
      $q .= "   AND (s.expiry_date IS NULL OR s.expiry_date > CURRENT_TIMESTAMP)";
      $q .= "   AND sl.story_id=s.story_id";
      $q .= "   AND l.location_id=sl.location_id";
      $q .= "   AND l.location_name='Featured News Item'";
      $q .= " ORDER BY story_date DESC, s.story_id DESC";
    }
    else {
      $q  = "SELECT * FROM ax_story s, ax_story_location sl, ax_content_location l";
      $q .= " WHERE s.visible=TRUE";
      $q .= "   AND s.deleted=FALSE";
      $q .= "   AND s.story_date <= CURRENT_TIMESTAMP";
      $q .= "   AND (s.expiry_date IS NULL OR s.expiry_date > CURRENT_TIMESTAMP)";
      $q .= "   AND sl.story_id=s.story_id";
      $q .= "   AND l.location_id=sl.location_id";
      $q .= "   AND l.location_name='Featured News Item'";
      if ($RESPONSE->microsites_mode == MICROSITES_ENABLED) {
        $q .= " AND NOT EXISTS (";
        $q .= "  SELECT * FROM ax_microsite_story ms";
        $q .= "   WHERE ms.story_id=s.story_id";
        $q .= " )";
      }
      $q .= " ORDER BY story_date DESC, s.story_id DESC";
    }
    $stories = dbrecordset($q);
    if ($stories->hasdata) {
      $storyid = $stories->field("story_id");
      $story = new story($storyid);
      $Ts->setstyle("background-color:#FAFDED;padding-top:15px;padding-bottom:5px;");
      if (file_exists($RESPONSE->site_docroot . "$IMAGESDIR/axyl_news.gif")) {
        $Ts->tr("background-color:black");
        $axfeature = new img("$IMAGESDIR/axyl_news.gif", "", "Feature");
        $Ts->td($axfeature->render());
      }
      $Ts->tr();
      $Ts->td("<h3>" . $story->story_headline . "</h3>", "padding-left:10px;padding-right:10px;");
      if ($story->story_precis != "") {
        $precis = $story->story_precis;
      }
      else {
        $precis = $story->make_precis(100);
      }
      $href = "/axyl-news.php";
      $href = href_addparm($href, "story_id", $storyid);
      $storylink = new anchor($href, "MORE..");
      $storylink->set_linkover_text("View story");
      $precis .= "&nbsp; " . $storylink->render();
      $Ts->tr();
      $Ts->td($precis, "padding-left:10px;padding-right:10px;padding-top:5px;padding-bottom:10px;");
      if (isset($story->story_icon)) {
        $Ts->tr();
        $icon = $story->render_story_icon();
        $iconlink = new anchor($href, $icon);
        $Ts->td($iconlink->render());
        $Ts->td_alignment("right");
      }
      $feat_news = $Ts->render();
    }
    else {
      if (file_exists($RESPONSE->site_docroot . "$IMAGESDIR/axyl_fig1.jpg")) {
        $axfig = new img("$IMAGESDIR/axyl_fig1.jpg", "fig1", "Axyl");
        $Ts->tr();
        $Ts->td($axfig->render());
        $Ts->td_alignment("center");
        $feat_news = $Ts->render();
      }
    }
  }
  // Return the asked-for story teaser..
  if (isset($feat_news)) {
    $s = $feat_news;
  }
  return $s;

} // featured_news_item

// -----------------------------------------------------------------------
// Clock showing just the time
function clock() {
  include_once("clock-defs.php");
  $clock = new digital_clock();
  $clock->settitle("Local Time");
  $clock->set_update_interval_secs(30);
  $clock->setstyle("width:80px;text-align:center;background-color:black;");
  $clock->set_css_time("font:bold 10pt arial,helvetica,sans-serif;padding:1px;color:white;");
  $clock->set_css_date("font:normal 8pt arial,helvetica,sans-serif;color:white;");

  return $clock->render();

} // clock

// -----------------------------------------------------------------------
// Clock showing the time and date
function clock_with_date() {
  include_once("clock-defs.php");
  $clock = new digital_clock();
  $clock->settitle("Local Time and Date");
  $clock->show_date();
  $clock->set_update_interval_secs(30);
  $clock->setstyle("width:80px;text-align:center;background-color:black;");
  $clock->set_css_time("font:bold 10pt arial,helvetica,sans-serif;padding:1px;color:white;");
  $clock->set_css_date("font:normal 8pt arial,helvetica,sans-serif;color:white;");

  return $clock->render();

} // clock_with_date

// -----------------------------------------------------------------------
?>