#!/bin/bash

# Build tar archive of the package..
PACKAGE=`head -n 1 debian/control | cut -f2 -d' '`
VERSION=`head -n 1 debian/changelog | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`
PKG_TGZ=${PACKAGE}_${VERSION}.tgz
echo "creating tarball ${PKG_TGZ}.."

THE_PWD=`pwd`
THE_DIR=`basename $THE_PWD`

# Update the init.d script from debian directory..
if [ -d debian ]; then
  [ ! -d etc ] && mkdir etc
  cp -a debian/${PACKAGE}.init ./etc/${PACKAGE}.init.d
  cd ..
  tar czhf $PKG_TGZ --exclude "*debian*" --exclude "*build*" --exclude "*CVS*" --exclude "*stamp" --exclude "*webprj" --exclude "Makefile" --exclude "*bak" $THE_DIR/

  cd $THE_PWD

  if [ -f ./etc/${PACKAGE}.init.d ] ; then
  	rm -f ./etc/${PACKAGE}.init.d
  fi
fi
