/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;

public class SocketTestSOS {
    public static void main(String[] args) throws Exception {
        String serverOutput;
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting = 9999L;
        long tClosedConnection = 9999L;
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            echoSocket = new Socket("192.168.4.20", 22224);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host: localhost.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: localhost.");
            System.exit(1);
        }
        tOpenedConnection = System.currentTimeMillis();
        String control = "CONTROL\nSub-Command: APPLICATION\nApplication: name\nField-Name: Id\nField-Type: Text\nField-Indexed: Yes\nField-Stored: Yes\nField-Name: Name\nField-Type: Text\nField-Indexed: Yes\nField-Stored: Yes\nDomain: name\nSort:\nQuery: Domain:name\nReturn: Id Name\nDefault-Field: Name\nEND\n";
        String control2 = "CONTROL\nSub-Command: APPLICATION\nApplication: sos2\nField-Name: Name\nField-Type: Text\nField-Indexed: Yes\nField-Stored: Yes\nField-Name: Location\nField-Type: Text\nField-Indexed: Yes\nField-Stored: No\nField-Name: Category\nField-Type: Text\nField-Indexed: Yes\nField-Stored: No\nDomain: sos2\nSort: Rank\nReturn: Id Name\nDefault-Field: Name\nEND\n";
        String delete = "CONTROL\nSub-Command: DELETE\nApplication: sos\nId: 1\nEND\n";
        String gc = "CONTROL\nSub-Command: GC\nEND\n";
        String unindex = "UNINDEX\nApplication: sos\nId: 2\nEND\n";
        String purge = "UNINDEX\nApplication: sos\nPurge: sdfsd\nId: 1\nEND\n";
        String query = "QUERY\nApplication: sos\nQuery: Details:egypt\nQuery: Name:mouse\nReturn: Id Name\nQuery: Location:10 13\nRange-Field: DisplayStartDate\nRange-From: 2002-01-01\nRange-To: 2002-03-01\nQuery: Cancelled:N\nLimit: 5\nEND\n";
        String query2 = "QUERY\nApplication:sos\nQuery: Cancelled:n\nSort: Cancelled\nLimit: 1\nEND\n";
        String query3 = "QUERY\nApplication: stuffonsale\nLimit: 10\nQuery: (Name:(infinity*) Teaser:(infinity*) Details:(infinity*)) AND Location:23 AND NOT Cancelled:Y\nEND\n";
        String query_count = "QUERY\nQuery: \nQuery: Domain:sos*\nLimit: 0\nReturn: Id Name\nEND\n";
        String index = "INDEX\nApplication: sos\nId: 1\nName: USB Mouse\nLocation: 10 11 23 24 21\nCategory: aa ab ac dd\nEND";
        String index2 = "INDEX\nApplication: stuffonsale\nId: t8\nName: Broken Keyboard\nDetails: This is a keyboard. It has been broken in a fit of computer rage.\nTeaser: Lucky dip.\nLocation: 23 24 21\nCategory: aa\nDisplayStartDate:2002-10-31 12:12:00\nSaleStartDate:2002-10-31 12:12:00\nEndDate:2002-11-10 12:12:00\nCancelled:N\nEND";
        String optimize = "CONTROL\nSub-Command: OPTIMIZE\nApplication: sos\nEND\n";
        String purge_optimize = "UNINDEX\nApplication: sos\nPurge: true\nEND\nCONTROL\nSub-Command: OPTIMIZE\nApplication: sos\nEND\n";
        String davidi = "INDEX\nApplication: david\nId: 1\nName: Red Person\nEND";
        String davidq = "QUERY\nApplication: david\nQuery: Name:red\nLimit: 3\nEND";
        String index_01 = "INDEX\nApplication: app1\nId: c001\nName: c\nDetails: computer\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
        String index_02 = "INDEX\nApplication: app1\nId: c002\nName: g\nDetails: game\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
        String index_03 = "INDEX\nApplication: app1\nId: c003\nName: cg\nDetails: computer game\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
        String index_04 = "INDEX\nApplication: app2\nId: c001\nName: c\nDetails: computer\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
        String index_05 = "INDEX\nApplication: app2\nId: c002\nName: g\nDetails: game\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
        String index_06 = "INDEX\nApplication: app2\nId: c003\nName: cg\nDetails: computer game\nLocation: 10 14\nCategory: 10 17 13\nDisplayStartDate:2002-04-08 12:12:12\nSaleStartDate:2002-04-08 12:12:12\nEndDate:2002-08-18 12:12:12\nCancelled: N\nEND";
        String index_both = "INDEX\nApplication: sos\nId:nospace\nName: Wireless Keyboard\nDetails: This is a keyboard. It uses no wires!\nTeaser: Surf the net from your couch.\nFeatures: black color, wireless\nLocation: 23 24 21\nCategory: aa\nDisplayStartDate:2002-11-10 12:12:00\nSaleStartDate:2002-10-31 12:12:00\nEndDate:2002-11-31 12:12:00\nCancelled:N\nEND\nINDEX\nApplication: sos\nId:   lotsaspace\nName: Broken Keyboard\nDetails: This is a keyboard. It has been broken in a fit of computer rage.\nTeaser: Lucky dip.\nFeatures: lots of keys\nLocation: 23 24 21\nCategory: aa\nDisplayStartDate:2002-10-31 12:12:00\nSaleStartDate:2002-10-31 12:12:00\nEndDate:2002-11-31 12:12:00\nCancelled:N\nEND";
        String command = query3;
        System.out.println("About to send command to server...\n");
        out.println(command);
        BufferedReader br = new BufferedReader(in);
        while ((serverOutput = br.readLine()) != null && !serverOutput.startsWith("END")) {
            System.out.println("from server: " + serverOutput);
        }
        tAfterExecuting = System.currentTimeMillis();
        out.close();
        br.close();
        in.close();
        echoSocket.close();
        tClosedConnection = System.currentTimeMillis();
        System.out.println("program has completed successfully");
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
        System.out.println("===================================================");
    }

    private static void listAll() throws Exception {
        System.out.println("============= beginning of listing ============");
        IndexReader r = IndexReader.open((String)"c:\\temp\\index");
        int num = r.numDocs();
        System.out.println("numDocs: " + num);
        int i = 0;
        while (i < num) {
            if (!r.isDeleted(i)) {
                Document d = r.document(i);
                System.out.println("d=" + d);
            }
            ++i;
        }
        r.close();
        System.out.println("============= end of listing ============");
    }
}

