/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class DemoQuery {
    public static void main(String[] args) throws Exception {
        String serverOutput;
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting = 9999L;
        long tClosedConnection = 9999L;
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            echoSocket = new Socket("localhost", 22222);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Unknown Host Exception. Cannot resolve host.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection.");
            System.err.println("Is the LuceneServer running?  Run the runserver.bat in another cmd window.");
            System.exit(1);
        }
        tOpenedConnection = System.currentTimeMillis();
        String query = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<LuceneRequest type=\"QUERY\">\n <Application>sos</Application>\n <Query>\n     Name:cat\n </Query>\n <Limit>3</Limit>\n</LuceneRequest>\n";
        System.out.println("===================================================");
        System.out.println("Query Request:");
        System.out.println("==============");
        System.out.println(query);
        System.out.println("===================================================");
        System.out.println("Query Response:");
        System.out.println("===============");
        out.println(query);
        BufferedReader br = new BufferedReader(in);
        while ((serverOutput = br.readLine()) != null) {
            System.out.println("from server: " + serverOutput);
        }
        if (serverOutput != null) {
            System.out.println("from server: " + serverOutput);
        }
        tAfterExecuting = System.currentTimeMillis();
        out.close();
        br.close();
        in.close();
        echoSocket.close();
        tClosedConnection = System.currentTimeMillis();
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
        System.out.println("===================================================");
    }
}

