/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import nz.net.catalyst.Log;
import nz.net.catalyst.lucene.server.Application;
import nz.net.catalyst.lucene.server.ApplicationMissingException;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;
import org.apache.lucene.index.IndexReader;

public class HealthCheck
implements IPackage,
Constants {
    private final Transmission input;
    private Application application;

    HealthCheck(Transmission transmission) {
        this.input = transmission;
    }

    Transmission execute() {
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        String appName = this.input.get("Application", NO_APP);
        try {
            this.application = Application.getAppOrDefault(appName);
        }
        catch (ApplicationMissingException e) {
            return this.error(e.getMessage());
        }
        IndexReader reader = null;
        this.input.setApplication(this.application);
        File luceneStoreDir = Application.getIndexDirectory(this.application);
        if (luceneStoreDir == null) {
            String message = "Application index directory undefined";
            return this.error(message);
        }
        try {
            try {
                reader = IndexReader.open((File)luceneStoreDir);
            }
            catch (FileNotFoundException e) {
                String message = "No index";
                Transmission transmission = this.error(message);
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable e2) {
                        String message2 = "Error closing IndexReader: " + e2.toString();
                        return this.error(message2);
                    }
                }
                return transmission;
            }
            catch (IOException e) {
                Transmission transmission;
                block21: {
                    String message = "IO exception: " + e.toString();
                    transmission = this.error(message);
                    if (reader == null) break block21;
                    try {
                        reader.close();
                    }
                    catch (Throwable e3) {
                        String string = "Error closing IndexReader: " + e3.toString();
                        return this.error(string);
                    }
                }
                return transmission;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {
                    String string = "Error closing IndexReader: " + e.toString();
                    return this.error(string);
                }
            }
        }
        String message = "healthy";
        response.add("Status", message);
        response.add("NumDocs", String.valueOf(reader.numDocs()));
        Log.info("healthcheck: " + message);
        return response;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        Log.error("healthcheck: " + message);
        return response;
    }
}

