/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import nz.net.catalyst.Config;
import nz.net.catalyst.Log;
import nz.net.catalyst.Util;

public class Main {
    public static final String CONFIG_SUFFIX = ".config";
    private static Main instance = new Main();
    protected String[] args = new String[0];
    protected Class application = Main.class;
    protected String[] startClassNames = null;
    protected Method[] StartList = null;

    public static void main(String[] args) {
        new Main().init(args);
    }

    public static Main getInstance() {
        return instance;
    }

    public void init(String[] args) {
        instance = this;
        this.setApplication(this.getClass());
        this.setArgs(args);
        this.loadConfig();
        this.initLogging();
        this.loadStartList();
        this.start();
    }

    protected void setArgs(String[] args) {
        this.args = args == null ? new String[]{} : args;
    }

    protected void setApplication(Class application) {
        this.application = application == null ? Main.class : application;
    }

    public Class getApplication() {
        return this.application;
    }

    public String[] getArgs() {
        return (String[])this.args.clone();
    }

    protected void initLogging() {
        Log.init();
    }

    protected void loadConfig() {
        File configFile;
        boolean configPropMissing;
        String configProp = String.valueOf(this.getApplication().getName()) + CONFIG_SUFFIX;
        String configFileName = System.getProperty(configProp);
        boolean bl = configPropMissing = configFileName == null;
        if (configPropMissing) {
            configFileName = String.valueOf(this.getBaseName()) + CONFIG_SUFFIX;
        }
        if ((configFile = new File(configFileName)).exists()) {
            try {
                Config.load(configFile);
                if (configPropMissing) {
                    System.setProperty(configProp, configFileName);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading config file: " + configFile.getPath(), e);
            }
        }
    }

    protected String getBaseName() {
        String className = this.getApplication().getName();
        int lastDot = className.lastIndexOf(46);
        return className.substring(lastDot + 1);
    }

    protected void loadStartList() {
        String baseClass = this.getApplication().getName();
        String startProp = String.valueOf(baseClass) + ".start";
        String startListProp = System.getProperty(String.valueOf(baseClass) + ".start");
        Log.debug("Getting start list: " + startProp + " = " + startListProp);
        this.startClassNames = Util.getCsv(startListProp);
        if (this.startClassNames == null || this.startClassNames.length == 0) {
            this.startClassNames = new String[]{baseClass};
        }
        this.resolveStartClasses();
    }

    protected void resolveStartClasses() {
        this.resolveStartMethods("Start", new Class[]{String[].class});
    }

    /*
     * Unable to fully structure code
     */
    protected void resolveStartMethods(String methodName, Class[] argListTypes) {
        starters = new ArrayList<Method>(this.startClassNames.length);
        i = 0;
        while (i < this.startClassNames.length) {
            block8: {
                block9: {
                    try {
                        Log.debug("Trying to load class: " + this.startClassNames[i]);
                        starter = Class.forName(this.startClassNames[i]);
                        Log.debug("Loaded class: " + starter.getName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Error loading class \"" + this.startClassNames[i] + '\"', e);
                    }
                    try {
                        startMethod = starter.getDeclaredMethod(methodName, argListTypes);
                        starters.add(startMethod);
                        break block8;
                    }
                    catch (NoSuchMethodException e) {
                        sb = new StringBuffer("(");
                        if (argListTypes == null) break block9;
                        arg = 0;
                        ** while (arg < argListTypes.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (arg > 0) {
                            sb.append(", ");
                        }
                        array = new StringBuffer();
                        cl = argListTypes[arg];
                        while (cl.isArray()) {
                            array.append("[]");
                            cl = cl.getComponentType();
                        }
                        sb.append(cl.getName());
                        sb.append(array);
                        ++arg;
                        continue;
                    }
                }
                sb.append(')');
                throw new RuntimeException("Error calling method \"" + methodName + sb + " in " + this.startClassNames[i], e);
            }
            ++i;
        }
        array = new Method[starters.size()];
        starters.toArray(array);
        this.setStartMethods(array);
    }

    protected void setStartMethods(Method[] list) {
        this.StartList = list == null ? new Method[]{} : list;
    }

    protected Method[] getStartMethods() {
        return this.StartList;
    }

    protected void start() {
        Method[] starters = this.getStartMethods();
        if (starters == null) {
            return;
        }
        int i = 0;
        while (i < starters.length) {
            try {
                Log.debug("About to invoke " + starters[i].getDeclaringClass().getName() + "." + starters[i].getName());
                starters[i].invoke(null, new Object[]{this.getArgs()});
                Log.debug("Returned from " + starters[i].getDeclaringClass().getName() + "." + starters[i].getName());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error activating " + starters[i].getName() + "() method in " + starters[i].getDeclaringClass().getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Exception in " + starters[i].getName() + "() method in " + starters[i].getDeclaringClass().getName(), e);
            }
            ++i;
        }
    }
}

