'Script file to generate a Hugin pto file from a series of images
'using autopano-sift

'Command line version (for Hugin)

'Version Information
'ver date       By             Comment
'1.0 2004-07-15 Ian Sydenham   Original Issue 


Option Explicit

   'Set Constants and Variables useable by all statements in this script (including subroutines and functions)
   Const KeyExt=".xml.gz"	'The file extension for keyfiles - added on to the image file name
   Const Size_dflt=1300		'Default size (MinDim) parameter for generatekeys
   Const Ransac_dflt="on"	'Default ransac setting for autopano
   Const Points_dflt=16		'Default points (maxmatches) parameter for autopano
   Const OutputFileName_dflt="Hugin.pto"	'Default output file for autopano
   Const Clean_dflt=False			'Default clean setting parameter for autopano
   Const GenerateKeysExe = "generatekeys.exe"  'The executable for generatingkeys
   Const AutopanoExe = "autopano.exe"          'The executable for autopano
   Const Ransac_on="on"		'The option used with autopano to select ransac check
   Const Ransac_off="off"	'The option used with autopano to select no ransac checking

   'Declare the other variables
   Dim ImageFileName		'The name of the Image File being checked	
   Dim KeyFileName		'The name of the Image key file being generated
   Dim shlcmd			'A string to be run as a shell command
   Dim Size			'The downscaled image sixe for generatekeys (MinDim)
   Dim Ransac			'on to use Ransac checking of control point pairs
   Dim Points			'The number of control point pairs to keep for autopano (maxmatches)
   Dim OutputFileName		'The name of the hugin script file to be created by autopano
   Dim Clean			'True to overwrite any existing key files
   Dim ArgVar			'The command line argument to process
   Dim i			'Loop counter
   Dim f			'File object
   Dim WshShell			'Script shell object
   Dim objArgs			'Command line arguments objects 
   Dim fso			'File System object
   Dim ImageFileList()		'array - dimesnioned later
   ReDim ImageFileList(2)	'Assume that there will be not more than x images
   				'(but if there are more then it is redimed later)
   Dim ImageFileCount
       ImageFileCount=0
   Dim dblquote			'
       dblquote=unescape("%22")	'the chacater "
   Dim KeyFileList		'A List of all the sift key files
       KeyFileList=""
   Dim ScriptfilePath		'The directory path of this script file 
   				'This is actually only *used* as the directory
   				'location of generatekeys and autopano
       ScriptFilePath=getScriptFilePath()
   
   
   'Create script objects
   Set objArgs = WScript.Arguments 'The list of files dropped into this icon, or the command line arguments
   Set fso = CreateObject("Scripting.FileSystemObject")
   Set WshShell = WScript.CreateObject("WScript.Shell") 
   

   'If there is not at least one command line argument then show the usage information
   If (WScript.Arguments.Count < 1) Then
      'Nothing to do, so show the usage message.
      Call Usage
      WScript.Quit
   End If

   
'  Set Defaults
   Size=Size_dflt
   OutputFileName=OutputFileName_dflt 
   Points=Points_dflt 
   Ransac=Ransac_dflt 
   Clean=Clean_dflt 


   'Check for Valid Command line Options
   For i = 0 to objArgs.Count - 1 
      ArgVar=objArgs(i)
      Select Case ArgVar
      Case "-o", "-O", "--output"
         If i+1<objArgs.Count then
            i=i+1 'skip to the next argument
            OutputFileName=objArgs(i)
         End If
      Case "-s", "-S", "--size"
         If i+1<objArgs.Count Then
            If isnumeric(objArgs(i+1)) then
               i=i+1 'skip to the the next argument
               Size=objArgs(i)
            End If
         End If
      Case "-p", "-P", "--points"
         If i+1<objArgs.Count Then
            If isnumeric(objArgs(i+1)) then
               i=i+1 'skip to the the next argument
               Points=objArgs(i)
            End If
         End If
      Case "-n", "-N", "--noransac"
         Ransac=Ransac_off
      Case "-c", "-C", "--clean"
         Clean=True
      Case "-h", "-H", "--help", "--"
         Call Usage
         WScript.Quit
      Case Else
	'Assume the argument is an image file.
	AddImageToList(ArgVar)
      End Select
   Next


   'GenerateKeys
   For i = 0 to ImageFileCount-1
	ImageFileName=ImageFileList(i)
      	KeyFileName=ImageFileName&KeyExt
      	KeyFileList=KeyFileList&" "&dblquote+KeyFileName&dblquote
        If (Clean or (not fso.FileExists(KeyFileName))) Then
               	shlcmd=dblquote & ScriptFilePath & "\" & generatekeysExe & dblquote & " " & dblquote&ImageFileName&dblquote &" "&dblquote&KeyFileName&dblquote&" "&cstr(Size)
         	WshShell.Run shlcmd, , true
        End If
   Next
   
  
  'Run Autopano
   if KeyFileList<>"" then
     shlcmd = dblquote &  ScriptFilePath & "\" & autopanoexe & dblquote& " --ransac " & Ransac & " --maxmatches " & Points & " " & dblquote&OutputFileName&dblquote & " "&KeyfileList
     WshShell.Run shlcmd, , true
   End If
   
   'Now delete the key files if they are not wanted
   For i = 0 to ImageFileCount-1
      	KeyFileName=ImageFileList(i)&KeyExt
        If fso.FileExists(KeyFileName) Then
        	fso.DeleteFile(filespec)      	
        End If
   Next
   

   WScript.Quit


'***************************************************
Sub usage()
'Sub to display the command line usage information

	Dim promptstr
	promptstr = "usage: " & WScript.ScriptName & " [options] image1 image2 [...]" & vbNewLine & _
	"options can be:" & vbNewLine & _
	"-o | --output name (Filename of created panorama project. Default: " & OutputFileName_dflt&")"&vbNewLine& _
	"-s | --size number (Halve the size of the images until width and height are smaller than number, default: "&Size_dflt&")"&vbNewLine&_
	"-p | --points number (The number of control points kept for each pair default: "&Points_dflt&")"&vbNewLine& _
	"-n | --noransac (Disable ransac detection, usefull for fisheye images. Default: Ransac "&Ransac_dflt&")"&vbNewLine& _
	"-c | --clean (True to overwrite keypoints detected in earlier runs. Default: "&Clean_dflt&")"&vbNewLine&vbNewLine
        msgbox promptstr, vbExclamation, "Help"
         
End Sub
 
'***************************************************
Sub AddImageToList(ImageName)

	'Check if the number of images is already more than can fit in the
	'ImageFileList, and if so then increase the array size 
	If ImageFileCount>Ubound(ImageFileList) Then
		'Add another 20 elements to the array
		Redim Preserve ImageFileList(ImageFileCount+20)
	End If
	
	'Now add the image to the list and increment the list counter
	ImageFileList(ImageFileCount)=ImageName
	ImageFileCount=ImageFileCount+1
	
End Sub


'***************************************************
Function getScriptFilePath() 
'Returns the pathname of this script file

   Dim Namepos, Pathonly, deduct
   
   Namepos = InStrRev(WScript.ScriptFullName, WScript.ScriptName, -1, 1)
   If Namepos >3 then 
     deduct=2 
   Else 
     deduct=1 
   End If
   Pathonly = mid(WScript.ScriptFullName,1,Namepos-deduct)
   getScriptFilePath=Pathonly
End Function

