/*
 * aurora - Communications with Magnetek Aurora Inverter
 *
 * Copyright (C) 2006-2010 Curtis J. Blank curt@curtronics.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program may be used and hosted free of charge by anyone for
 * personal purposes as long as this and all included copyright
 * notice(s) remain intact.
 *
 * Obtain permission before selling the code for this program or
 * hosting this software on a commercial website, excluding if it is
 * solely hosted for distribution, that is allowable . In all cases
 * copyright must remain intact.
 *
 * This work based on Magnetek's 'Aurora PV Inverter - Communications
 * Protocol -' document, Rel. 1.8 09/05/2005
 * Staring with v1.5-0 this work based on Power One's 'Aurora Inverter
 * Series - Communication Protocol -' document, Rel. 4.6 25/02/09
 *
 * Special thanks to Tron Melzl at Magnetek for all his help including,
 * but not limited to, supplying the Communications Protocol document
 *
 */

#define	VersionMH	"1.6.0"

#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef __cplusplus
#define extern "C" {		/* respect c++ callers */
#endif

#define	ProgramName	"aurora"

typedef int BOOL;		/* yet another bool definition */
#define TRUE 1
#define FALSE 0

typedef unsigned char BYTE;
typedef unsigned short WORD;
typedef unsigned long DWORD;

#define LOBYTE(w)	((BYTE)(w))
#define HIBYTE(w)	((BYTE)(((WORD)(w) >> (BYTE)8) & 0xff))

extern BOOL bVerbose;                           /* Verbose Mode */
extern BOOL bColumns;
extern BOOL bGetInvTime;
extern BOOL bGetLocTime;
extern BOOL bGetDSP;
extern BOOL bGetEnergy;
extern BOOL bCommCheck;
extern BOOL bColOutput;
extern BOOL bCalcGridPwr;
extern BOOL bRptReties;
extern BOOL bRptReadPause;
extern char RunTime[18];
extern float yCost;
extern int yTimeout;
extern long PID;
extern int yMaxAttempts;
extern int yReadPause;

extern FILE *outfp;

extern int ModelID;

extern int ClrSerLock(long PID);
extern int RestorePort(int fdser);

#define	ttyLCKloc	"/var/lock/LCK.."	/* location and prefix of serial port lock file */

/* command structure */
#define	cAddress	0
#define	cCommand	1
#define cCommandEnd	2
#define	cParam1		2
#define	cParam2		3
#define	cParam3		4
#define	cParam4		5
#define	cParam5		6
#define	cParam6		7
#define cCRC_L		8
#define	cCRC_H		9
#define cEND		10
#define cSIZE		10

/* answer structure */
#define	aState		0
#define aMState		1
#define	aParam1		2
#define	aParam2		3
#define	aParam3		4
#define	aParam4		5
#define	aCRC_L		6
#define	aCRC_H		7
#define aEND		8
#define aSIZE		8

#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __MAIN_H__ */

