/*
    This file is part of xmms-curses, copyright 2003-2005 Knut Auvor Grythe.

    xmms-curses is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    xmms-curses is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with xmms-curses; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _XMMS_MAIN_H_

#define _XMMS_MAIN_H_

#define PACKAGE "audtty"
#define VERSION "0.1"
#define COPYRIGHT "Copyright 2005 Kiyoshi Aman <kiyoshi.aman@gmail.com>" 

#define CONFIG_MAX_LINE_LENGTH 1024
#define SLEEP_TIME 500000

#include <ncurses.h>
#include <glib.h>

#ifndef COLOR_DEFAULT
#define COLOR_DEFAULT -1
#endif

typedef struct {
	WINDOW *status;
	WINDOW *title;
	WINDOW *list;
	int term_resized;
} windows;

typedef struct {
	int show_numbers;
	int read_length;
	int read_title;
	int read_all;
} prefs;

void paint_playback(void);
void paint_songinfo(void);
void mvwtitledhline(WINDOW *win, int y, char *label);
void resize_windows(void);

#endif
