/*
 *  ap_config.h
 *
 *  Copyright 2009 Arnaud Soyez <weboide@codealpha.net>
 *
 *  This file is part of AudioPreview.
 *
 *  AudioPreview is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  AudioPreview is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AudioPreview.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef AP_CONFIG_H
#define AP_CONFIG_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gst/gst.h>
#include <unistd.h>
#include <termios.h>
#include "stream.h"

typedef enum {
  START_PLAYING_START                  = 0,
  START_PLAYING_MIDDLE                 = 1,
  START_PLAYING_END                    = 2,
  START_PLAYING_ANYWHERE               = 3
} StartPlayingPosition;


typedef struct
{
  gchar*      locale;
  gboolean    verbose;
  gboolean    quiet;
  gboolean    show_version;
  gboolean    debug;
  GList*      playlist;      ///< holds all the stream's to play
  GList*      glist_current; ///< acts like an index inside playlist
  gint        duration;
  gint        maxduration;
  gboolean    use_playbin2;
  gboolean    skip_null_state;
  gboolean    fastseek;
  gboolean    no_video;
  gboolean    no_audio;
  gboolean    entirely;
  gboolean    shuffle;
  gboolean    loop;
  gint        volume;
  gint        terminal_cols;
  gchar*      playlist_from_file;
  gchar*      colors;
  gboolean    want_colors;
  struct  termios       savedttystate;
  struct  _Stream       *current;
  StartPlayingPosition  position;
} apconfig;

apconfig ap_config;

void         ap_config_init             (apconfig* ap);
void         config_debug_print_start_position  ();

#endif /* AP_CONFIG_H */
