#pragma once
#ifndef	VIRTOBJ_DEFINE
#define	VIRTOBJ_DEFINE

/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

#ifndef _PURE
#define _PURE =0
#endif // _PURE

enum    alignType { CENTRE, LEFT, RIGHT };

#include "main.h"

#include "player.h"

class VIRTUAL_OBJECT
  {
  private:
    // copy-ctor and assign operator are private, so the compiler won't create implicit ones!
    inline VIRTUAL_OBJECT (VIRTUAL_OBJECT &sourceVirtObj _UNUSED) { }
    inline const VIRTUAL_OBJECT& operator= (const VIRTUAL_OBJECT &sourceVirtObj) { return(sourceVirtObj); }

  public:
    BOX	_current, _old;
    alignType	_align;
    BITMAP	*_bitmap;
    ENVIRONMENT	*_env;
    GLOBALDATA	*_global;
    int	_requireUpdate;
    int	_index;
    PLAYER *player;
    double	x, y;
    double	xv, yv;
    int	angle;
    int	destroy;
    int	age, maxAge;
    int	physics;	// Special physics processing?

    /* --- constructor --- */
    inline VIRTUAL_OBJECT():_bitmap(NULL),_env(NULL),_global(NULL),x(0),y(0),xv(0),yv(0),angle(0),destroy(FALSE),
                            age(0),maxAge(-1),physics(0)
    {
      _current.x = 0;
      _current.y = 0;
      _current.w = 0;
      _current.h = 0;
      _old.x = 0;
      _old.y = 0;
      _old.w = 0;
      _old.h = 0;
    }

    /* --- destructor --- */
    inline virtual	~VIRTUAL_OBJECT ()
      {
        _bitmap = NULL;
        // player, _env and _global must be handled by descendants!
      }

    /* --- non-inline methods --- */
    void	update();

    /* --- pure virtual (abstract) methods --- */
    virtual int	  isSubClass (int classNum)_PURE;
    virtual int	  getClass ()_PURE;
    virtual void  setEnvironment(ENVIRONMENT *env)_PURE; // This is virtual, so objects add themselves to _env!

    /* --- inline methods --- */
    inline void	requireUpdate ()
    {
      _requireUpdate = TRUE;
    }

    inline virtual void	initialise ()
    {
      age = 0;
      maxAge = -1;
      x = 0;
      y = 0;
      xv = 0;
      yv = 0;
      destroy = false;
      _current.x = 0;
      _current.y = 0;
      _current.w = 0;
      _current.h = 0;
      _old.x = 0;
      _old.y = 0;
      _old.w = 0;
      _old.h = 0;
    }

    inline virtual int	applyPhysics ()
    {
      x += xv;
      y += yv;

      return (0);
    }

    inline void	setGlobalData (GLOBALDATA *global)
    {
      if (!_global || (_global != global))
        _global = global;
    }

    inline virtual void	draw (BITMAP *dest)
    {
      if (!destroy)
        {
          rotate_sprite (dest, _bitmap,
                         (int)x - (_bitmap->w / 2),
                         (int)y - (_bitmap->h / 2),
                         itofix (angle));
          if (angle == 0)
            {
              setUpdateArea ((int)x - (_bitmap->w / 2 + 1),
                             (int)y - (_bitmap->h / 2 + 1),
                             _bitmap->w + 2, _bitmap->h + 2);
            }
          else
            {
              int length = MAX (_bitmap->w, _bitmap->h);
              length += MIN (_bitmap->w, _bitmap->h) / 2;
              setUpdateArea ((int)x - (length/2),
                             (int)y - (length/2),
                             length, length);
            }
          requireUpdate ();
        }
    }

    inline void	setUpdateArea (int left, int top, int width, int height)
    {
      _current.x = left;
      _current.y = top;
      _current.w = width;
      _current.h = height;
    }

    inline void	addUpdateArea (int left, int top, int width, int height)
    {
      if (left < _current.x)
        _current.x = left;
      if (top < _current.y)
        _current.y = top;
      if (left + width > _current.x + _current.w)
        _current.w = width;
      if (top + height > _current.y + _current.h)
        _current.h = height;
    }

    inline int	getIndex ()
    {
      return (_index);
    }
  };

#endif // VIRTOBJ_DEFINE
