/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */

#include "virtobj.h"
#include "environment.h"

/** @brief update
  *
  * This method triggers an update of the canvas (aka drawing area) with the dimensions and position
  * of this object.
  */
void VIRTUAL_OBJECT::update()
{
  if (_requireUpdate)
    {
      int changed;

      if (_current.w)
        {
          if (_align == LEFT)
            {
              _env->make_update (_current.x, _current.y,
                                 _current.w, _current.h);
            }
          else if (_align == RIGHT)
            {
              _env->make_update (_current.x - _current.w,
                                 _current.y - _current.h,
                                 _current.w, _current.h);
            }
          else
            {
              _env->make_update (_current.x - (_current.w / 2),
                                 _current.y - (_current.h / 2),
                                 _current.w + 2, _current.h + 2);
            }
        }

      if ((_old.x == _current.x) &&
          (_old.y == _current.y) &&
          (_old.w == _current.w) &&
          (_old.h == _current.h))
        changed = FALSE;
      else
        changed = TRUE;

      if (changed)
        {
          if (_old.w)
            {
              if (_align == LEFT)
                {
                  _env->make_update (_old.x, _old.y,
                                     _old.w, _old.h);
                }
              else if (_align == RIGHT)
                {
                  _env->make_update (_old.x - _old.w,
                                     _old.y - _old.h,
                                     _old.w, _old.h);
                }
              else
                {
                  _env->make_update (_old.x - (_old.w / 2),
                                     _old.y - (_old.h / 2),
                                     _old.w + 2, _old.h + 2);
                }
            }
          _old.x = _current.x;
          _old.y = _current.y;
          _old.w = _current.w;
          _old.h = _current.h;
        }
      _requireUpdate = FALSE;
    }
}
