#ifndef GLOBALDATA_DEFINE
#define GLOBALDATA_DEFINE
/*
 * atanks - obliterate each other with oversize weapons
 * Copyright (C) 2003  Thomas Hudson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * */


#include "main.h"

#define DEFAULT_SCREEN_WIDTH 800
#define DEFAULT_SCREEN_HEIGHT 600

#define LANGUAGE_ENGLISH 0.0
#define LANGUAGE_PORTUGUESE 1.0
#define LANGUAGE_FRENCH 2.0
#define LANGUAGE_GERMAN 3.0
#define LANGUAGE_SLOVAK 4.0

#define COLOUR_THEME_REGULAR 0.0
#define COLOUR_THEME_CRISPY 1.0

#define GAME_NAME_LENGTH 64

#define VIOLENT_DEATH_OFF 0
#define VIOLENT_DEATH_LIGHT 1
#define VIOLENT_DEATH_MEDIUM 2
#define VIOLENT_DEATH_HEAVY 3

#define MAX_INTEREST_AMOUNT 100000
#define MAX_TEAM_AMOUNT 500000

enum skipComputerPlayType
{
  SKIP_NONE, SKIP_HUMANS_DEAD// , SKIP_AUTOPLAY
};

class PLAYER;
class TANK;
class GLOBALDATA
  {
  private:
    // copy-ctor and assign operator are private, so the compiler won't create implicit ones!
    inline GLOBALDATA (GLOBALDATA &sourceGlobal _UNUSED) {  }
    inline const GLOBALDATA& operator= (const GLOBALDATA &sourceGlobal) { return(sourceGlobal); }

  public:
    inline ~GLOBALDATA()
      {
        if (tank_status)
          free(tank_status);
        tank_status[0] = 0x0;
      }

    int	WHITE, BLACK, PINK;
    double	slope[360][2];

    char	*dataDir;
    char    *configDir;
    BOX	*updates, *lastUpdates, window;
    int	updateCount, lastUpdatesCount;
    int	stopwindow;
    int	command;
    double  frames_per_second;

    PLAYER	**allPlayers;
    int	numPermanentPlayers;
    PLAYER	**players;
    int	numPlayers;
    int	numHumanPlayers;
    int	computerPlayersOnly;
    double	skipComputerPlay;	/* options requires doubles - grr */
    /* It's a lot simpler than having
     * special cases for each type */
    int	numTanks;
    int	maxNumTanks;
    TANK	*currTank;

    int	updateMenu;

    int	curland, cursky;

    int	colourDepth;
    int	screenWidth, screenHeight;
    int	halfWidth, halfHeight;
    int     width_override, height_override;
    double  temp_screenWidth, temp_screenHeight;
    gfxDataStruct	gfxData;
    DATAFILE	*SOUND;

    bool            full_screen;
    int		cacheCirclesBG ;	/* This is just a flag, so it need only be
								an integer, not a double */

    /* Logically, these three variables should be ints.  However, converting
    them to ints (or even an enumerated type) would require some rewritting
    of the options function - and that's a lot of work. 2003.09.05 */
    /* Hence being double. 2004.01.05 */
    double ditherGradients;
    double detailedLandscape;
    double detailedSky;
    double os_mouse;          // whether we should use the OS or custom mouse
    double colour_theme;     // land and sky gradiant theme

    /* All this money data; couldn't it be moved into some separate data
    structure or object */
    /* It could, but it's not a problem */
    double	startmoney;
    double	interest;
    double	scoreHitUnit;
    double	scoreSelfHit;
    double	scoreUnitDestroyBonus;
    double	scoreUnitSelfDestroy;
    double	scoreRoundWinBonus;
    double  sellpercent;

    /* double? */
    /* double for options() reasons, no messing about with casting or
     * special cases. */
    double	turntype;
    double	rounds;
    int     currentround;
    double  sound;
    double  language;
    int     name_above_tank;
    int     tank_status_colour;
    char  * tank_status;
    char    game_name[GAME_NAME_LENGTH];
    double  load_game;
    double  campaign_mode;
    double  violent_death;
    double  saved_game_index;
    char    **saved_game_list;
    double  max_fire_time;
    bool close_button_pressed;

    GLOBALDATA ();
    void	initialise ();
    int     saveToFile_Text (FILE *file);
    int     saveToFile (ofstream &ofsFile, bool aIsSaveGame = false);
    int     loadFromFile_Text (FILE *file);
    int     loadFromFile (ifstream &ifsFile);
    void	addPlayer (PLAYER *player);
    void	removePlayer (PLAYER *player);
    PLAYER	*getNextPlayer (int *playerCount);
    PLAYER	*createNewPlayer (ENVIRONMENT *env);
    void	destroyPlayer (PLAYER *player);
    char    *Get_Config_Path();
    bool    Check_Time_Changed();      // check to see if one second has passed
    bool		bIsGameLoaded;
    bool		bIsBoxed;
    int			iHumanLessRounds;
    double	dMaxVelocity;
#ifdef DEBUG_AIM_SHOW
    bool bASD;
#endif
  };

#endif
