/*
 * wrapendpoint.hxx
 *
 * OpenH323 Wrapper Library
 *
 * Copyright (c) 2002-2005 InAccess Networks
 * Michalis Manousos <manousos@inaccessnetworks.com>
 * Dimitris Economou <decon@inaccessnetworks.com>
 *
 * This file is part of "H.323 support for ASTERISK"
 *
 * "H.323 support for ASTERISK" is free software;
 * you can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation;
 * either version 2 of the License, or (at your option) any later version. 
 *
 * "H.323 support for ASTERISK" is distributed in the hope that it will be 
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details. 
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 * $Id: wrapendpoint.hxx,v 1.1.1.1 2007/06/04 10:55:35 mmanousos Exp $
 *
 */

///////////////////////////////////////////////////////////////////////////////

#ifndef	_WRAPENDPOINT_HXX
#define	_WRAPENDPOINT_HXX

#include "wrapper.hxx"

/** 
 * The wrapper descendant of the H323EndPoint class 
 */
class WrapH323EndPoint : public H323EndPoint {

	PCLASSINFO(WrapH323EndPoint, H323EndPoint);

	protected:
	PStringArray	*GWPrefix;
	void			SetEndpointTypeInfo(H225_EndpointType &) const;

	enum {
		Dialtone,
		AnsweringCall,
		ConnectingCall,
		WaitingForAnswer,
		CallInProgress,
		CallHungup,
		StateIllegal,
	} state;
 
	public:
	WrapH323EndPoint(char **, int);
	~WrapH323EndPoint();
	call_ret_val_t MakeCall(const PString &, PString &, unsigned int *, user_details_t *);
	BOOL ClearCall(const PString &, H323Connection::CallEndReason 
					reason = H323Connection::EndedByLocalUser);
	BOOL ClearCallSynchronous(const PString &, H323Connection::CallEndReason
					reason = H323Connection::EndedByLocalUser);
	BOOL IsConnectionCleared(const PString &);
	BOOL IndicateCall(const PString & token, indication_t type);
	BOOL ChangeMode(const PString & token, const PString & newMode);
	BOOL SetSoundChannelPlayDevice(const PString &);
	BOOL SetSoundChannelRecordDevice(const PString &);
	BOOL OpenAudioChannel(H323Connection & connection, BOOL, unsigned, H323AudioCodec &);
	//BOOL OnStartLogicalChannel(H323Connection &, H323Channel &);
	//void OnClosedLogicalChannel(H323Connection &, const H323Channel &);
	BOOL OnCallTransferInitiate(H323Connection &, const PString &);
	H323Connection *SetupTransfer(const PString &, const PString &,
			const PString &, PString &, void *);
    void OnConnectionEstablished(H323Connection &, const PString &);
	void OnConnectionCleared(H323Connection &, const PString &);
	H323Connection * CreateConnection(unsigned callReference, void *userData,
			H323Transport *transport, H323SignalPDU *setupPDU);
	void SetGatekeeperTimeToLive(int);
	void SendUserInput(const PString &, const PString &);
	void OnUserInputString(H323Connection &, const PString &);
	unsigned GetBandwidthAvailable();
	void GetConnectionInfo(const PString &, char*, int);
	void OnRTPStatistics(const H323Connection &, const RTP_Session &) const;
	BOOL AnswerCall(const PString &);
	void SetClearCallCause(const PString & token, int cause);
	cap_type_t		GetCodecFromFormat(OpalMediaFormat &);
	int				GetFrames(const OpalMediaFormat);
	void 			SetFrames(const OpalMediaFormat, int);
	void			RemoveAllCapabilities();

	// Number of frames for supported codecs
	int 			frames_L16, frames_PCMU, frames_PCMA;
	int				frames_G726, frames_G728, frames_G729;
	int				frames_G7231, frames_GSM;
};

#endif	// _WRAPENDPOINT_HXX
// End of file //////////////////////////////////////////////////////////////
