// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __TemplateInstanceUnit__
#define __TemplateInstanceUnit__

/** \file
 *  Special token unit for C++ template instances. */

#include "Puma/CUnit.h"

namespace Puma {


class CTemplateInstance;


/** \class TemplateInstanceUnit TemplateInstanceUnit.h Puma/TemplateInstanceUnit.h
 *  Specialized token unit for C++ template instances. Additionally
 *  provides information about the template instance and the unit
 *  containing its point of instantiation. */
class TemplateInstanceUnit : public CUnit {
  Unit* m_ContainingUnit;
  CTemplateInstance* m_TemplateInstance;

public:
  /** Constructor.
   *  \param err The error stream on which to report errors.
   *  \param containing Pointer to the unit containing the point of instantiation.
   *  \param ti The template instance information object. */
  TemplateInstanceUnit(ErrorSink& err, Unit* containing, CTemplateInstance* ti) :
    CUnit(err),
    m_ContainingUnit(containing),
    m_TemplateInstance(ti) {}

  /** Destructor. */
  virtual ~TemplateInstanceUnit() {}

  /** Always returns true because this is a unit for a template instance. */
  virtual bool isTemplateInstance() const { return true; }

  /** Set the unit containing the point of instantiation.
   *  \param u Pointer to the unit. */
  void ContainingUnit(Unit* u) { m_ContainingUnit = u; }
  /** Get the unit containing the point of instantiation. */
  Unit* ContainingUnit() const { return (Unit*)m_ContainingUnit; }

  /** Set the template instance information object.
   *  \param ti The template instance info. */
  void TemplateInstance(CTemplateInstance* ti) { m_TemplateInstance = ti; }
  /** Get the template instance information object. */
  CTemplateInstance* TemplateInstance() const { return (CTemplateInstance*)m_TemplateInstance; }
};


} // namespace Puma

#endif /* __TemplateInstanceUnit__ */
