// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __c_comment_recognizer_h__
#define __c_comment_recognizer_h__

#include "Puma/MappedOrangeRecognizer.h"
#include "Puma/CScanBuffer.h"

namespace Puma {


class CCommentRecognizer {
public:
  typedef enum { NO_COMMENT, SL_COMMENT, ML_COMMENT } Mode;

private:
  static MappedOrangeRecognizer<CScanBuffer> comment_recognizer;   
  static MappedOrangeRecognizer<CScanBuffer> sl_comment_recognizer;   
  static MappedOrangeRecognizer<CScanBuffer> ml_comment_recognizer;   
  Mode comment_mode;

public:
  CCommentRecognizer () : comment_mode (NO_COMMENT) {}
  int recognize (CScanBuffer *scan_buffer, int &expr, int &len);
  void mode (Mode mode) { comment_mode = mode; }
  Mode mode () { return comment_mode; }
};


} // namespace Puma

#endif /* __c_comment_recognizer_h__ */
