/* :: ascii-jump project
   :: $Id: main.c,v 1.2 2003/03/02 21:24:14 loth Exp $
   
   :: copyright (c) 2003 :: grzegorz moskal, g.moskal@opengruop.org
   :: license gnu gpl v 2						*/

#define MAIN_C
#include "main.h"

struct widget *screen;
struct hill *hills;
struct frame *skin;
int status;

static void menu(int key)
{
	screen->draw(screen);
	screen->key(screen, key);
}

static void game(int key)
{
	game_draw(jumper);
	if (jumper_service(jumper, key) == 0) {
		status = MENU;
		sl_cls();
	}
}

void game_draw(struct object *jumper)
{
	matrix_draw();
	matrix_service();
	matrix_move(jumper->vx);
	jumper_draw(jumper);
	hill_draw(jumper);
}

void game_show(void)
{
	sl_cls();
	status = GAME;
}

void quit(void)
{	
	status = QUIT;
}

static int init(void)
{
	rand_init();
	
	sl_init();
	matrix_init(0, 0, WIDTH, HEIGHT);
	
	if ((skin = skin_make("gfx")) == NULL)
		if ((skin = skin_make(DATADIR"/gfx")) == NULL)
			return 1;
			
	if ((hills = hills_init("hills", &nhills)) == NULL)
		if ((hills = hills_init(DATADIR"/hills", &nhills)) == NULL)
			return 2;
	
	main_init();
	cup_init();
	train_init();

	return 0;
}

int resize()
{
	struct object *j;
	if (sl_screen_size_changed == 0)
		return 0;

	sl_cls();
	
	if (sl_screen_width < 40 || sl_screen_height < 16) 
		return 1;
	
	sl_fini();
	sl_init();
	sl_screen_size_changed = 0;
	
	for (j = jumpers; j; SWITCH(j)) {
		j->current_x =  sl_screen_width/2-4;
		j->current_y =  sl_screen_height/2-2;
	}
	
	jumper->current_x =  sl_screen_width/2-4;
	jumper->current_y =  sl_screen_height/2-2;
	
	matrix_free();
	matrix_init(0, 0, WIDTH, HEIGHT);
	
	return 0;
}


int main(int argc, char **argv)
{
	int key;

	if (parse_cmdline(argc, argv) == 0)
		return 0;

	if ((key = init()) != 0)
		return key;
		
	intro();
	
	for (;;) {
		if (resize())
			continue;

		key = sl_getch2();
		switch (status) {
		case MENU:
			menu(key);
			break;
		case GAME:
			game(key);
			break;
		case CUP:
			cup(key);
			break;
		case QUIT:
			goto end;
		}
		sl_refresh();
		usleep(((status != MENU)+1) * (0xdead - 0xcafe/0x9));
	}
	
	end :;
	sl_fini();
	return 0;		
}
