/* $Id: MenuView.cpp,v 1.8 2003/03/23 20:09:25 mrq Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef WIN32
 #include <windows.h>
#endif

#include <Ark/ArkSystem.h>
#include <Client/MenuView.h>
#include <iostream>
#include <sstream>

namespace Client
{  
   MenuButton::MenuButton ()
   {
      m_State = NORMAL;
   }

   MenuButton::MenuButton (int xpos, int ypos,
			   Ark::Cache *cache,
			   const Ark::String &imgname,
			   const Ark::String &action,
			   scalar scrfactor)
   {
      const char *names[3] = {"", "_hover", "_press"};

      for (size_t i = 0; i < NUMIMAGES; ++i)
      {
	 Ark::String fullname = (Ark::String("{menu}/") + imgname + names[i] + ".png");
	 cache->Get(Ark::V_TEXTURE, fullname, m_Images[i]);
	 m_Images[i]->Configure();
      }

      m_State = NORMAL;
      m_X = xpos;
      m_Y = ypos;
      m_Action = action;
      m_ScrFactor = scrfactor;
   }

   MenuButton::~MenuButton()
   {
   }

   bool
   MenuButton::InArea (int x, int y)
   {
      if (x >= (m_X * m_ScrFactor) &&
	  x < (m_X + m_Images[0]->GetWidth())*m_ScrFactor && 
	  y >= (m_Y * m_ScrFactor) &&
	  y < (m_Y + m_Images[0]->GetHeight())*m_ScrFactor)
	 return true;
      else
	 return false;
   }
		       
   void
   MenuButton::Render(UIRenderer *ui)
   {
      int mx, my;
      SDL_GetMouseState (&mx, &my);

      if (m_Images[m_State])
      {
	 if (m_State != PRESS)
	 {
	    if (InArea (mx, my))  m_State = HOVER;
	    else m_State = NORMAL;
	 }
	    
	 ui->SetTexture (m_Images[m_State]);
	 ui->DrawTexturedRectangle
	    ((int)(m_X * m_ScrFactor),
	     (int)(m_Y * m_ScrFactor),
	     (int)(m_Images[m_State]->GetWidth() * m_ScrFactor),
	     (int)(m_Images[m_State]->GetHeight() * m_ScrFactor));
	 ui->Flush();
      }
   }

   bool
   MenuButton::HandleMButton (bool down, int b, int x, int y)
   {
      if (down && InArea(x,y) && b == 1)
      {
	 m_State = PRESS;
	 return true;
      }
      else if (!down && m_State == PRESS && b == 1)
      {
	 g_Client->HandleMenuString(m_Action);
	 Ark::Sys()->Log("User selected '%s'\n", m_Action.c_str());
	 m_State = NORMAL;
	 return true;
      }

      return false;
   }

   bool
   MenuButton::HandleMotion (int state, int x, int y)
   {
      return true;
   }
   
   ////////////////////////////////////////////////////////////////////////


   MenuView::MenuView (UIRenderer *rnd) 
   {
      Ark::Config menucfg;
      Ark::Cache *cache = &rnd->Rdr()->GetCache();

      menucfg.Load("{menu}/menu.cfg");

      ////////////
      cache->Get(Ark::V_TEXTURE,
		 Ark::String("{menu}/") + menucfg.GetStr("menu::BgImage", "")
		 + ".png",  m_Bg);

      if (m_Bg) m_Bg->Configure();
      const float scrfactor = scalar(rnd->width) / scalar(m_Bg->GetWidth());

      ///////////
      size_t numbuttons = menucfg.GetInt("menu::NumButtons", 0);

      m_Children.resize(numbuttons);
      for (size_t i = 0; i < numbuttons; ++i)
      {
	 std::ostringstream sstr;
	 sstr << "menu::Button" << i << "::";
	 Ark::String prefix = sstr.str();

	 m_Children[i] = MenuButton
	    (menucfg.GetInt(prefix + "X", 0),
	     menucfg.GetInt(prefix + "Y", 0),
	     cache,
	     menucfg.GetStr(prefix + "Image", ""),
	     menucfg.GetStr(prefix + "Action", ""),
	     scrfactor);
      }
   }

   MenuView::~MenuView ()
   {
   }
   
   void
   MenuView::Render(UIRenderer *ui)
   {
      ui->SetTexture (m_Bg);
      ui->DrawTexturedRectangle (0, 0, ui->width, ui->height);

      // Render my children.
      std::vector<MenuButton>::iterator i;
      for (i = m_Children.begin(); i != m_Children.end(); ++i)
	 i->Render (ui);
   }

   void
   MenuView::HandleMButton (bool down, int b, int x, int y)
   {
      std::vector<MenuButton>::iterator i;
	    
      for (i = m_Children.begin(); i != m_Children.end(); ++i)
      {
	 if (i->HandleMButton (down, b, x, y))
	    return;
      }
   }

   void
   MenuView::HandleMotion (int state, int x, int y)
   {
      std::vector<MenuButton>::iterator i;
	    
      for (i = m_Children.begin(); i != m_Children.end(); ++i)
      {
	 if (i->HandleMotion (state, x, y))
	    return;
      }
   }

}

