#!/usr/bin/python3
import itertools
import os
import sys
import unittest
import traceback

if os.path.exists("arkose/__init__.py"):
    sys.path.insert(0, ".")

import arkose


class ArkoseTests(unittest.TestCase):
    def test_run_all_tests(self):
        for fstype, fssize, network, xserver, dbus, pulseaudio, ctype in \
            itertools.product(
                ("ext4", "tmpfs"),
                (None, 2000),
                ("none", "direct", "filtered"),
                ("none", "isolated", "direct"),
                ("none", "system", "session", "both"),
                (True, False),
                ("cow", "bind")):

            print ("Testing: %s, %s, %s, %s, %s, %s, %s" % (fstype, fssize,
                                                            network, xserver,
                                                            dbus, pulseaudio,
                                                            ctype))

            fail = False
            try:
                container = arkose.ArkoseContainer(fstype=fstype,
                                                   fssize=fssize,
                                                   network=network,
                                                   xserver=xserver,
                                                   dbus=dbus,
                                                   pulseaudio=pulseaudio,
                                                   ctype=ctype, cow=['/var'],
                                                   bind=['/tmp'],
                                                   restrict=['%s/Desktop' % (
                                                       os.getenv("HOME"))])

                container.run_command("mount")
                container.run_command("route -n")
                container.run_command("su %s -c xrandr" %
                                      os.getenv("SUDO_USER",
                                                os.getenv("USER", "root")))

            except:
                print(traceback.print_exc())
                fail = True

            finally:
                try:
                    container.cleanup()
                except:
                    print(traceback.print_exc())
                    fail = True

            if fail:
                sys.exit(1)
