# -*- coding: utf-8 -*-
#####################################################################
#  Rafael Proença <cypherbios@ubuntu.com>
#  Laudeci Oliveira <laudeci@gmail.com> 
#
#  Copyright 2006 APTonCD DevTeam.
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published
#  by the Free Software Foundation; version 2 only.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#####################################################################
import dbus

class DeviceList:
	
	def __init__(self):
		# Get a connection to the SYSTEM bus
		self.bus = dbus.SystemBus()
		
		# Get a handle to the HAL service
		self.hal_object = self.bus.get_object('org.freedesktop.Hal', '/org/freedesktop/Hal/Manager')
		self.hal_iface = dbus.Interface(self.hal_object, 'org.freedesktop.Hal.Manager')
	
	def get_devices(self):
		# get a list of optical devices with data discs in, for FV installs
		vollabel = {}
		volpath = {}
		volmount = {}
		drives = []
		# Find info about all current present media
		for d in self.hal_iface.FindDeviceByCapability("volume"):
			vol = self.bus.get_object("org.freedesktop.Hal", d)
			if vol.GetPropertyBoolean("volume.is_disc") and vol.GetPropertyBoolean("volume.disc.has_data"):
				devnode = vol.GetProperty("block.device").encode('utf8')
				label = vol.GetProperty("volume.label").encode('utf8')
				if label == None or len(label) == 0:
					label = devnode
				vollabel[devnode] = label
				volmount[devnode] = vol.GetProperty("volume.mount_point").encode('utf8')
				volpath[devnode] = d

		for d in self.hal_iface.FindDeviceByCapability("storage.cdrom"):
			dev = self.bus.get_object("org.freedesktop.Hal", d)
			devnode = dev.GetProperty("block.device").encode('utf8')
			if vollabel.has_key(devnode):
				drives.append([vollabel[devnode], volmount[devnode], volpath[devnode]])
		
		return drives
