
#ifndef _ACFG_H
#define _ACFG_H

#include "config.h"
#include "meta.h"

class hostdata;

static const int RESERVED_DEFVAL = -4223;

namespace acfg
{

extern mstring cachedir, logdir, confdir, fifopath, user, group, pidfile, 
reportpage, vfilepat, pfilepat, wfilepat, agentname, remoteport, adminauth, bindaddr, port, sUmask,
dontcacherq, dontcachetgt, dontcache, mirrorsrcs, requestapx;

extern int debug, offlinemode, foreground, verbose, stupidfs, forcemanaged, 
verboselog, extreshhold, exfailabort, tpstandbymax, tpthreadmax, dnscachetime, dlbufsize,
exporigin, logxff, oldupdate, recompbz2, nettimeout, updinterval, forwardsoap, dirperms, fileperms;

// processed config settings
extern tHttpUrl proxy_info;
extern mstring agentheader;

bool SetOption(const mstring &line, bool bQuiet=false);
void ReadConfigDirectory(const char*);

//! Prepare various things resulting from variable combinations, etc.
void PostProcConfig();

// TODO: document me
// throw away the rewritten part of the path, foo/debian/bla.deb -> bla.deb,
// no slash needed with backends...
				
const mstring * GetRepNameAndPathResidual(const tHttpUrl & in, mstring & sRetPathResidual);

/*
struct tBackendDesc : public tHttpUrl
{
	struct tHookHandler
	{
		virtual void PostponeDownCmd()=0;
		virtual void UpCmd()=0;
		virtual void PreUpCmd()=0;
	};
	tHookHandler *m_pHooks;
	inline tBackendDesc(const tHttpUrl& src) : tHttpUrl(src), m_pHooks(NULL) {};
	inline tBackendDesc() : m_pHooks(NULL) {};
};
*/

class tHostiVec : public MYSTD::vector<tHttpUrl>
{
public:
	struct IHookHandler
	{
		virtual void JobRelease()=0;
		virtual void JobConnect()=0;
	};
	IHookHandler *m_pHooks;
	tHostiVec() : MYSTD::vector<tHttpUrl>(), m_pHooks(NULL) {};
	virtual ~tHostiVec();
};

tHostiVec * GetBackendVec(const mstring * vname);

time_t ExecutePostponed();

extern tStrMap localdirs;
extern NoCaseStringMap mimemap;

extern mstring cacheDirSlash; // guaranteed to have a trailing path separator

}

namespace rechecks
{
typedef enum {
	FILE_PKG,
	FILE_INDEX,
	FILE_INVALID
} eFileKind;
eFileKind GetFiletype(const mstring &);
bool MatchWhitelist(const mstring &);
bool MatchUncacheableRequest(const mstring &);
bool MatchUncacheableTarget(const mstring &);
}

#endif
