

#include "meta.h"
#include "lockable.h"

#include "maintenance.h"
#include "expiration.h"
#include "pkgimport.h"
#include "showinfo.h"
#include "aclogger.h"
#include "filereader.h"
#include "acfg.h"
#include "acbuf.h"

#include <stdio.h>
#include <string.h>
//#include <iostream>

#include <unistd.h>
#include <sys/socket.h>
#include <netdb.h>

using namespace MYSTD;

#define MAINT_HTML_DECO "maint.html" 

#ifndef MSG_MORE
#define MSG_MORE 0
#endif

maintenance::maintenance(int fd) : 
	m_reportFD(fd),
	m_szDecoFile(NULL)
{	
}

maintenance::~maintenance()
{
}

/// @brief Sends a HTTP chunk with string contents
/// To terminate the transfer, add an empty string with force flag

void maintenance::SendMsg(const string & x) 
{
    SendMsg(x.data(), x.length());
}

inline bool maintenance::_SendHelper(const char *data, size_t len, int flags)
{
	while(len>0)
	{
		int r=send(m_reportFD, data, len, flags);
		if(r<0)
			return false;
		data+=r;
		len-=r;
	}
	return true;
}

void maintenance::SendMsg(const char *data, size_t len)
{
	if(!data || !len || m_reportFD<0)
		return;
	
	char buf[23];
	int l=sprintf(buf, "%x\r\n", (UINT) len);
	_SendHelper(buf, l, MSG_MORE);
	_SendHelper(data, len, MSG_MORE);
	_SendHelper("\r\n", 2, 0);
}

void maintenance::EndTransfer() 
{
    send(m_reportFD, "0\r\n\r\n", 5, 0);
}


void maintenance::SendDecoration(bool bBegin, const char *httpcode, const char *szDecoFile)
{
	if (bBegin)
	{
		send(m_reportFD, "HTTP/1.1 ", 9, MSG_MORE);
		send(m_reportFD, httpcode, strlen(httpcode), MSG_MORE);
		const char head[] = " OK\r\nConnection: Keep-Alive\r\n"
			"Transfer-Encoding: chunked\r\nContent-Type: text/html\r\n"
			"\r\n";
		send(m_reportFD, head, sizeof(head)-1, MSG_MORE);
	}
	
	acbuf m_deco;
	char *mark(NULL);
	
	if(szDecoFile && m_deco.initFromFile((acfg::confdir+sPathSep+szDecoFile).c_str()))
		mark=strchr(m_deco.c_str(), '~');
	
	// deco file specified and loaded?
	if(mark)
	{
		if(bBegin)
			m_deco.erase(mark-m_deco.rptr());
		else
			m_deco.drop(mark-m_deco.rptr()+1);
		string sDeco(m_deco.rptr(), m_deco.size());
		SetStyle(sDeco);
		SendMsg(sDeco);
	}	
	else
		SendMsg(bBegin?"<html><body>":"</html></body>");
	
	if(!bBegin)
		EndTransfer();
}

void DispatchAndRunMaintTask(const MYSTD::string &cmd, int conFD)
{	
	maintenance *pWorker(NULL);
/*	
	tStrPos pos=cmd.find("maintid=");
	if(pos!=stmiss)
	{
		const char *end(NULL), *str=cmd.c_str();
		time_t id=strtol(cmd.c_str()+pos+8, &end, 10);
		if(id==0)
		{
			aclog::err("Invalid maintid submitted by the user.");
			return;
		}
		if(end) cmd.erase(pos, end-str);
	}
	else
	{
#error fixme, Location: oder so
	}
	*/
	try {
		if(cmd.find("?doExpire")!=stmiss)
			pWorker=new expiration(conFD);
		else if(cmd.find("?doImport")!=stmiss)
			pWorker=new pkgimport(conFD);
		else if(0==cmd.compare(0, acfg::reportpage.size(), acfg::reportpage))
			pWorker=new reportgen(conFD);
		else
			pWorker=new showinfo(conFD);
		
		pWorker->Run(cmd);
	}
	catch(...)
	{ /* whatever */ };
	if(pWorker)
		delete pWorker;
}

void maintenance::SetStyle(string &s)
{
	tStrPos pos=0;

	acbuf buf;
	if( ! buf.initFromFile( (acfg::confdir+sPathSep+"style.css").c_str()) )
		return;
	
	while(stmiss != (pos = s.find("$STYLE", pos)))
	{
		//cerr << "replacing " << s.substr(pos, 6) << " with " << buf.c_str()<<endl;
		s.replace(pos, 6, buf.c_str());
		pos+=buf.size();
	}
}

string maintenance::GetHostname()
{
	
	struct sockaddr_storage ss;
	socklen_t slen = sizeof(ss);
	char hbuf[NI_MAXHOST];
	
	if (0==getsockname(m_reportFD, (struct sockaddr *)&ss, &slen) &&
			0==getnameinfo((struct sockaddr*) &ss, sizeof(ss), hbuf, sizeof(hbuf), 
							NULL, 0, NI_NUMERICHOST))
	{
		return hbuf;
	}
	
	return "IP-of-this-cache-server";

}

