
#define LOCAL_DEBUG
#include "debug.h"

#include "meta.h"
#include "con.h"
#include "job.h"
#include "header.h"
#include "dlcon.h"
//#include "acdb.h"
//#include "acdlman.h"
#include "acbuf.h"
//#include "taskIndex.h"
//#include "taskChecksum.h"
//#include "lockguard.h"

#include <sys/select.h>
#include <signal.h>
#include <string.h>
#include <errno.h>
#include <iostream>

//#define barf(x) { if(! remCount) write(confd, x, strlen(x)); return; }

using namespace MYSTD;

// main constructor
con::con(int fdId, const char *c) :
	condition(),
    m_confd(fdId),
    m_bStopActivity(false)
{
	m_pDlClient=NULL;
	
	if(c) // if NULL, pick up later when sent by the wrapper
		m_sClientHost=c;
	
    ldbg("Creating con " << fdId << " for " << c);

    wakepipe[0]=wakepipe[1]=-1;
    
    if(pipe(wakepipe) == 0) {
    	set_nb(wakepipe[0]);
    	set_nb(wakepipe[1]);
    }
    else
    	m_bStopActivity=true;
    
};

/*
// local type constructor
con::con(int fdId) :
    confd(fdId),
    terminating(false),
    needs_command(true),
    localmode(0)
{
    ldbg("Creating con " << fdId << " for a local connection");
};


con::con() :
    confd(-1),
    terminating(false),
    needs_command(true),
    localmode(0)
{
    ldbg("Creating dummy con for a internal jobs");
};

*/

void con::SignalStop() {
    setLockGuard;
    m_bStopActivity=true;
    write(wakepipe[1], "", 1); // poke select
    notifyAll();
}

void con::ShutDown()
{
	// no double calls
	if(m_confd>=0) 
	{
		shutdown(m_confd, SHUT_RDWR);
		close(m_confd);
		m_confd=-1;
	}
}

con::~con() {
	ldbg("Destroying connection...");

	if (wakepipe[0]>=0)
		close(wakepipe[0]);

	if (wakepipe[1]>=0)
		close(wakepipe[1]);
	
	MYSTD::list<job*>::iterator jit;
	for (jit=m_jobs2prep.begin(); jit!=m_jobs2prep.end(); jit++)
		delete *jit;
	for (jit=m_jobs2send.begin(); jit!=m_jobs2send.end(); jit++)
		delete *jit;

    
	setLockGuard;
    if(m_pDlClient) 
    {
    	m_pDlClient->SignalStop();
    	pthread_join(m_dlerthr, NULL);
    	
    	delete m_pDlClient;
    	m_pDlClient=NULL;
    	
    }
    
    aclog::flush();
    /*
    map<string,dlcon*>::iterator ait = agents.begin();
    ldbg("Releasing agents");
    for(;ait!=agents.end();ait++)  {
        ait->second->setTerminating();
    }*/
    
}

void con::HelpLoop() {
    
	signal(SIGPIPE, SIG_IGN);
	   
	lockguard g(*this);
	
    while(!m_bStopActivity) {
    	if(m_jobs2prep.empty()) {
    		wait();
    		continue;
    	}
    	job *j = *(m_jobs2prep.begin());
    	ldbg("Preparing job: " << j);
    	m_jobs2prep.pop_front();
    	
    	g.unLock();
    	j->PrepareDownload(); // may lock
    	ldbg("Prepared job: " << j);
    	g.reLock();
    	
    	m_jobs2send.push_back(j);
    	write(wakepipe[1], "", 1); // poke select
    	ldbg("Get another job?");
    }
    
}

void con::WorkLoop() {
    
	signal(SIGPIPE, SIG_IGN);
	
    acbuf inBuf;
    inBuf.init(32*1024);
    
    int maxfd=MYSTD::max(wakepipe[0], m_confd);
    
    // TODO: murks, shutdown controllieren... socket value?
    while(!m_bStopActivity) {
        fd_set rfds, wfds;
        FD_ZERO(&wfds);
        FD_ZERO(&rfds);
        
        FD_SET(m_confd, &rfds);
        if(inBuf.freecapa()==0)
        	return; // shouldn't even get here
        
        job *pjSender(NULL);
        
        // prepare to send data or to be notified by helper
        
        FD_SET(wakepipe[0], &rfds);
        
        {
        	setLockGuard;
			if ( !m_jobs2send.empty())
			{
				pjSender=*(m_jobs2send.begin());
				FD_SET(m_confd, &wfds);
			}
		}
        
        
        ldbg("select con");

        if(0 > select(maxfd+1, &rfds, &wfds, NULL, NULL))
        {
           ldbg("select error in con, errno: " << errno);
           return; // FIXME: good error message?
        }
        ldbg("select con back");

        if(FD_ISSET(m_confd, &rfds)) {
            int n=inBuf.sysread(m_confd);
            ldbg("got data: " << n <<", inbuf size: "<< inBuf.size());
            if(n<=0) // error, incoming junk overflow or closed connection
                return;
        }

        // split new data into requests
        while(inBuf.size()>0) {
            header h;
            int nConsumed=h.LoadFromBuf(inBuf.rptr(), inBuf.size());
            ldbg("header parsed how? " << nConsumed);
            if(nConsumed==0)
            { // Either not enough data received, or buffer full; make space and retry
            	inBuf.move();
                break;
            }
            if(nConsumed<0) 
            {
                ldbg("Bad request");
                return;
            }
            if (nConsumed>0)
				inBuf.drop(nConsumed);

			if (m_sClientHost.empty()) // may come from wrapper... MUST identify itself
			{
				m_sClientHost=h.get("Host");
				if (m_sClientHost.empty())
					return;
				continue;
			}
            
            ldbg("Parsed REQUEST:" << h.as_string(false));
            ldbg("Rest: " << inBuf.size());

            job * j = new job(h, this);
            setLockGuard;
            m_jobs2prep.push_back(j);
            notifyAll();
        }
        
        if(inBuf.freecapa()==0)
        	return; // cannot happen unless being attacked
        
        if(FD_ISSET(wakepipe[0], &rfds))
		{
			//ldbg("Aufgeweckt, outbuf:" << outBuf);
			int tmp;
			while(read(wakepipe[0], &tmp, 1) > 0);
			continue;
		}

		if(FD_ISSET(m_confd, &wfds) && pjSender)
		{
			ldbg("Sending data of " << pjSender);
			switch(pjSender->SendData(m_confd))
			{
				case(R_FAILURE):
					return;
				case(R_DONE):
				{
					delete pjSender;
					pjSender=NULL;
					setLockGuard;
					m_jobs2send.pop_front();
				}
				case(R_AGAIN):
				default:
					break;
			} 
        }
	}
}

void * _StartDownloader(void *pVoidDler)
{
	static_cast<dlcon*>(pVoidDler) -> WorkLoop();
	return NULL;
}

bool con::SetupDownloader()
{

	if (m_pDlClient)
		return true;

	try
	{
		m_pDlClient=new dlcon;
	}
	catch(MYSTD::bad_alloc)
	{
		return false;
	}

	if (0==pthread_create(&m_dlerthr, NULL, _StartDownloader,
			(void *)m_pDlClient))
	{
		return true;
	}
	delete m_pDlClient;
	m_pDlClient=NULL;
	return false;
}
