#ifndef _HEADER_H
#define _HEADER_H

#include <string>
#include <map>
#include "meta.h"

class header {

   public:
      enum eHeadType {
         INVALID,
         HEAD,
         GET,
         ANSWER
      };

      eHeadType type;

      MYSTD::string frontLine;
      unsigned int len;

      /*
      // for answer
      int status;

      // for request
      MYSTD::string uri;
      */
      
      //header(const char *safestr);
      header();
      //header(const header &copysrc);
      //~header();
      
      /*!
       * Read buffer to parse one string. Optional offset where to begin to
       * scan.
       * 
       * return: 
       * 0: incomplete, needs more data
       * -1: invalid
       *  >0: length of the processed data
       */
      int LoadFromBuf(const char *src, UINT length); 
      int LoadFromFile(const MYSTD::string & sPath);
      
      //! returns byte count or negative errno value
      int StoreToFile(const MYSTD::string &sPath);
      
      void set(const MYSTD::string &key, const MYSTD::string &value);
      void set(const MYSTD::string &key, long nValue);
      void del(const MYSTD::string &key);
      MYSTD::string getLike(const MYSTD::string &pattern);
      bool getUri(MYSTD::string & sRet);
      int getStatus() const;
      void SetStatusLine(MYSTD::string sLine);
      MYSTD::string get(const MYSTD::string &key) const;
      MYSTD::string as_string(bool bTerminateIt) const;
      //MYSTD::string as_buffer(acbuf & outBuf) const;
      //void clearFields() { fields.clear();};
      // bool hasField(const char *foo);
      void fix();
      void clear();
      
   private:
	      
      //char *buffer;
      //MYSTD::map<MYSTD::string, MYSTD::string, ltstring> fields;
	   NoCaseStringMap fields;
};

#endif
