
#ifndef _FILEITEM_H
#define _FILEITEM_H

#include <string>

#include "config.h"
#include "lockable.h"
#include "filestorage.h"
#include <header.h>

typedef unsigned int FiStatus;
#define FIST_UNKNOWN 		0
#define FIST_NOMOREUSERS 	1
#define FIST_ERROR 			2
#define FIST_DLRUNNING 		4
#define FIST_COMPLETE 		8
#define FIST_EOF			16 // set when the seen size is equal to the final size, i.e. file won't grow anymore
#define FIST_ISUPTODATE		32
#define FIST_NONFATAL		64 // declares non-fatal errors, i.e. client can continue

// some fileitem members need to know them...
class fileitem;
class acbuf;
typedef SHARED_PTR<fileitem> tFileItemPtr;

class fileitem : public condition, public dlstorage // to track filesize changes
{

public:
	
	// public constructor wrapper, get a unique object from the map
	static tFileItemPtr GetFileItem(MYSTD::string sPath, bool bIsDynamicFiletype); // also opens the cached file and increases reference count
	~fileitem();
	void DelUser(); // decrease reference count
	
	// client instruments
	// blocks untill new size is larger than given size or error happens, reported via retcode and sErrorOut
	FiStatus TrackStatusChanges(off_t const nKnownSize, off_t & nNewSizeOut, MYSTD::string & sErrorOut);
	// like TrackStatus..., not blocking
	FiStatus GetStatus(long & nNewSizeOut, MYSTD::string & sErrorOut);
	
	int GetFileFd();
	uint64_t GetTransferCount();
	
	// downloader instruments
	virtual bool AssignDownloaderUnlessConflicting();
	virtual bool ReleaseDownloaderUnlessBusy();
	virtual bool StoreNewHead(const header & h);
	virtual long StoreData(const char *data, const unsigned int size, off_t nOffset);
	virtual void Finalize(long nNewContLen);
	virtual void SetFailureMode(MYSTD::string const & FailureMessage, bool bNonFatal=false);
	virtual void AddTransferCount(UINT nLen);
	virtual void GetStatusEx(long & nCachedLen, long &nContLen, bool & bIsDynType);
	virtual MYSTD::string ToString() { return m_sKey; }
	virtual void GetHeader(header &hOut);
	
protected:
	header m_RetHead;
	MYSTD::string m_sError, m_sPath, m_sKey;
	
	bool m_bHaveDownloader:1;
	bool m_bIsUptodate:1;
	bool m_bIsDynType:1;
	bool m_bFilesLocked:1;
	bool m_bRemovalScheduled:1;
	bool m_bNonFatal:1;
	
	uint64_t m_nIncommingCount;
	long m_nCachedLen;
	long m_nContLen;
	off_t m_nCachedWritePos;
	
	int m_nUserCount;
	int m_filefd;
	
	fileitem(MYSTD::string sPath, bool bDynType);
	fileitem();
	void _LoadCached();
	FiStatus _GetStatus(long & nNewSizeOut, MYSTD::string & sErrorOut);
	void _SetFailureMode(MYSTD::string const & FailureMessage, bool bNonFatal);
	
	bool _StoreNewHead(const header & h);
	bool _StoreLocalHead();
	
};



#endif


