# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os

try:
    from mod_python import apache, util, Cookie, Session
except ImportError:
    if 'APACHE_OPENID_MOCK' in os.environ:
        pass
    else:
        raise

from apache_openid.utils.baseutil import BaseUtil


class ModPythonUtil(BaseUtil):

    def cls_field_storage(self):
        return util.FieldStorage

    def cls_session(self):
        return Session.Session

    def const_done(self):
        return apache.DONE

    def const_http_forbidden(self):
        return apache.HTTP_FORBIDDEN

    def const_http_moved_temporarily(self):
        return apache.HTTP_MOVED_TEMPORARILY

    def const_ok(self):
        return apache.OK

    def const_server_return(self):
        return apache.SERVER_RETURN

    def func_add_cookie(self):
        return Cookie.add_cookie

    def func_get_cookies(self):
        return Cookie.get_cookies

    def func_log_error(self):
        return apache.log_error
