
'\"
'\" The contents of this file are subject to the AOLserver Public License
'\" Version 1.1 (the "License"); you may not use this file except in
'\" compliance with the License. You may obtain a copy of the License at
'\" http://aolserver.com/.
'\"
'\" Software distributed under the License is distributed on an "AS IS"
'\" basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
'\" the License for the specific language governing rights and limitations
'\" under the License.
'\"
'\" The Original Code is AOLserver Code and related documentation
'\" distributed by AOL.
'\" 
'\" The Initial Developer of the Original Code is America Online,
'\" Inc. Portions created by AOL are Copyright (C) 1999 America Online,
'\" Inc. All Rights Reserved.
'\"
'\" Alternatively, the contents of this file may be used under the terms
'\" of the GNU General Public License (the "GPL"), in which case the
'\" provisions of GPL are applicable instead of those above.  If you wish
'\" to allow use of your version of this file only under the terms of the
'\" GPL and not to allow others to use your version of this file under the
'\" License, indicate your decision by deleting the provisions above and
'\" replace them with the notice and other provisions required by the GPL.
'\" If you do not delete the provisions above, a recipient may use your
'\" version of this file under either the License or the GPL.
'\" 
'\"
'\" $Header: /cvsroot/aolserver/aolserver/doc/ns_at.n,v 1.5 2006/04/13 19:05:43 jgdavidson Exp $
'\"
'\" 
.so man.macros

.TH ns_at n 4.0 AOLserver "AOLserver Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
ns_atclose, ns_atexit, ns_atshutdown, ns_atsignal \- Facilities to register a script callback.
.SH SYNOPSIS
.nf
\fBns_atclose \fIscript\fR
\fBns_atexit \fIscript\fR
\fBns_atshutdown \fIscript\fR
\fBns_atsignal \fIscript\fR
.fi
.BE
.SH DESCRIPTION
.PP
These commands register a callback to execute a later time.  The
callbacks are executed once in the context of the current Tcl
interpreter.
.TP
\fBns_atclose \fIscript\fR
Invoke given script when the current connection is closed. The
callback can be registered within the Tcl interpreter associated with
the current HTTP connection; if no connection exists, and error is
returned.
.TP
\fBns_atexit \fIscript\fR
Invoke given script before the AOLserver exists after all virtual
servers have stopped.
.TP
\fBns_atshutdown \fIscript\fR
Invoke given script when the current virtual server is shutdown during
AOLserver exit.
.TP
\fBns_atsignal \fIscript\fR
Invoke given script when a SIGHUP signal is received in the main startup
thread of the AOLserver.
.SH "SEE ALSO"
ns_shutdown(n), ns_kill(n)
.SH KEYWORDS
shutdown, callback
