/*
 * file.c
 * This file is part of anyPaper
 *
 * Copyright (C) 2008 - Sergio Rodrigues de Oliveira Filho 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * "You should have received a copy of the GNU General Public License 
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

#include <gtk/gtk.h>

#include "config.h"
#include "variables.h"

static void update_preview_cb (GtkFileChooser *file_chooser, gpointer data)
{
	GtkWidget *preview;
	char *filename;
	GdkPixbuf *pixbuf;
	gboolean have_preview;

	preview = GTK_WIDGET (data);
	filename = gtk_file_chooser_get_preview_filename (file_chooser);

	pixbuf = gdk_pixbuf_new_from_file_at_size (filename, 128, 128, NULL);
	have_preview = (pixbuf != NULL);
	g_free (filename);

	gtk_image_set_from_pixbuf (GTK_IMAGE (preview), pixbuf);
	if (pixbuf) g_object_unref (pixbuf);

	gtk_file_chooser_set_preview_widget_active (file_chooser, have_preview);
}

void file( GtkWidget *widget, gpointer data )
{
	GtkWidget *dialog, *window;
	GtkWidget *preview2;

	preview2 = gtk_image_new ();
	window = GTK_WIDGET (data);

	dialog = gtk_file_chooser_dialog_new ("Open File", GTK_WINDOW(window), GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
	gtk_file_chooser_set_preview_widget (GTK_FILE_CHOOSER (dialog), preview2);
	gtk_file_chooser_set_filename(GTK_FILE_CHOOSER (dialog), gtk_entry_get_text (GTK_ENTRY (file_entry)));
	g_signal_connect (dialog, "update-preview", G_CALLBACK (update_preview_cb), preview2);

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT) 
	{
		gtk_entry_set_text (GTK_ENTRY (file_entry), gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog)));
		make_image(gtk_combo_box_get_active (GTK_COMBO_BOX (combo)), gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog)), preview);
	}

	gtk_widget_destroy (dialog);
}

void save_file_def( GtkWidget *widget, gpointer data )
{
	GtkWidget *dialog, *dialog_error, *window;

	window = GTK_WIDGET (data);

	dialog = gtk_file_chooser_dialog_new ("Default file",
					      GTK_WINDOW(window),
					      GTK_FILE_CHOOSER_ACTION_SAVE,
					      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					      GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
					      NULL);
	gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), FALSE);

	gtk_file_chooser_set_filename (GTK_FILE_CHOOSER (dialog), gtk_entry_get_text (GTK_ENTRY (def_entry)));


	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
	{
		char *filename, *down_filename;

		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		down_filename = g_ascii_strdown (filename, -1);

		if ((g_str_has_suffix (down_filename, ".jpg")) || (g_str_has_suffix (down_filename, ".jpeg")) || (g_str_has_suffix (down_filename, ".png"))) gtk_entry_set_text (GTK_ENTRY (def_entry),filename);
		else
		{
			dialog_error = gtk_message_dialog_new (GTK_WINDOW (window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "Invalid format");
			gtk_window_set_title (GTK_WINDOW (dialog_error), "Error");
		 	g_signal_connect_swapped (dialog_error, "response", G_CALLBACK (gtk_widget_destroy), dialog_error);
			gtk_widget_show(dialog_error);
		}
		g_free (filename);
		g_free (down_filename);
	}

	gtk_widget_destroy (dialog);
}

void save_file_as( GtkWidget *widget, gpointer data )
{
	GtkWidget *dialog, *dialog_error, *window;

	window = GTK_WIDGET (data);

	dialog = gtk_file_chooser_dialog_new ("Save as...",
					      GTK_WINDOW(window),
					      GTK_FILE_CHOOSER_ACTION_SAVE,
					      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
					      GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
					      NULL);
	gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), TRUE);

	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), g_path_get_dirname (gtk_entry_get_text (GTK_ENTRY (file_entry))));
	gtk_file_chooser_set_current_name (GTK_FILE_CHOOSER (dialog), "Untitled image.png");


	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
	{
		char *filename, *down_filename;

		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		down_filename = g_ascii_strdown (filename, -1);

		if ((g_str_has_suffix (down_filename, ".jpg")) || (g_str_has_suffix (down_filename, ".jpeg"))) gdk_pixbuf_save (pixbuf, filename, "jpeg", NULL, "quality", "100", NULL);
		else if(g_str_has_suffix (down_filename, ".png")) gdk_pixbuf_save (pixbuf, filename, "png", NULL, NULL);
		else
		{
			dialog_error = gtk_message_dialog_new (GTK_WINDOW (window), GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "Invalid format");
			gtk_window_set_title (GTK_WINDOW (dialog_error), "Error");
		 	g_signal_connect_swapped (dialog_error, "response", G_CALLBACK (gtk_widget_destroy), dialog_error);
			gtk_widget_show(dialog_error);
		}
		g_free (filename);
		g_free (down_filename);
	}

	gtk_widget_destroy (dialog);
}

