/* Copyright (C) 2002, 2003, 2004 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __XSLCOMPILER_HPP
#define __XSLCOMPILER_HPP

#include <PlatformSupport/FormatterListener.hpp>
#include <XalanTransformer/XalanTransformer.hpp>
#include <map>
#include "compiler.hpp"
#include "xslParseErrorHandler.hpp"

#ifdef XERCES_HAS_CPP_NAMESPACE
using namespace XERCES_CPP_NAMESPACE;
#endif
#ifdef XALAN_HAS_CPP_NAMESPACE
using namespace XALAN_CPP_NAMESPACE;
#endif


/** @addtogroup compilers
    @{ */
/** XSL compiler
    @todo It shouldn't be necessary to specify \c FormatterListener::eFormat
    @date Thu Mar 10 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class XSLCompiler: public Compiler
{
 public:
  /// Constructor
  XSLCompiler( const std::string &_xslScriptFileName,
               FormatterListener::eFormat _format,
               const std::string &_outputEncoding,
               const std::string &_schemaURI,
               const std::string &_emptyResult = "",
               XSLParseErrorHandlerPtr _xslParseErrorHandler =
               XSLParseErrorHandlerPtr( new XSLParseErrorHandler ) )
    throw (Error);
  /// Destructor
  virtual ~XSLCompiler(void);
  ///
  virtual void translate( std::istream &inputStream,
                          std::ostream &outputStream ) const
    throw (Error);
  ///
  void setEmptyResult( const std::string &_emptyResult )
    { emptyResult = _emptyResult; }
  ///
  void setParseErrorHandler( XSLParseErrorHandlerPtr _xslParseErrorHandler )
    { xslParseErrorHandler = _xslParseErrorHandler; }
  ///
  void setParam( const std::string &name, const std::string &value );
  ///
  bool clearParam( const std::string &name );
protected:
  ///
  std::string xslScriptFileName;
  ///
  FormatterListener::eFormat format;
  ///
  XalanTransformer theXalanTransformer;
  ///
  const XalanCompiledStylesheet *compiledStyleSheet;
  ///
  std::string outputEncoding;
  ///
  std::string schemaURI;
  ///
  std::string emptyResult;
  ///
  std::map< std::string , std::string > params;
  ///
  XSLParseErrorHandlerPtr xslParseErrorHandler;
};

///
typedef boost::shared_ptr< XSLCompiler > XSLCompilerPtr;

///@}

#endif
