 /* Copyright (C) 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __MYSQLSERVER_HPP
#define __MYSQLSERVER_HPP

#include "include.hpp"
#include <mysql/mysql.h>
#include "server.hpp"

/** @defgroup mysqlCpp MySQL C++ Wrappers
    The MySQL C++ wrappers are offering a higher-level interface to MySQL.
    @{ */
/** Store information for connecting to a MySQL server.
    @date Sun Feb 19 2006
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class MySQLServer: public Server
{
public:
  /** Constructor.
      Store information for connecting to a MySQL server.
      @param _userName Name of database user.
      @param _passWord Password of database-user. */
  MySQLServer( const std::string &_userName,
               const std::string &_passWord ) throw (Error):
    Server( _userName ), passWord( _passWord ) {}
  ///
  virtual void connect( const std::string &database, MYSQL *m )
    throw (Error) = 0;
  ///
  MYSQL *getConnection(void) { return &connection; }
protected:
  /** Connection to MySQL server.
      The connection is required for creating databases and user-accounts. */
  MYSQL connection;
  ///
  std::string passWord;
};

/// Smart-Pointer referencing a MySQL-server.
typedef boost::shared_ptr< MySQLServer > MySQLServerPtr;

///@}

#endif
