<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:output method="xml" indent="yes" version="1.0" encoding="UTF-8"/>

  <xsl:param name="lfile">dictionary.xml</xsl:param>
  <xsl:param name="lname">en</xsl:param>

  <xsl:template match="/insert|/sqlout">

    <article class="whitepaper" xml:lang="{$lname}">

      <artheader>
        <title>
          <xsl:value-of select="document($lfile)/dictionary/entry[@text='Cookbook']"/>
        </title>
        <author>
          <xsl:value-of select="document($lfile)/dictionary/entry[@text='generated by AnyMeal']"/>
        </author>
      </artheader>

      <!-- Convert all recipes. -->
      <!-- <xsl:apply-templates select="recipe"/> -->
      <xsl:for-each select="recipe/categories/category[position()=1 and not(.=../preceding::categories/category[position()=1])]">
        <xsl:sort/>
        <sect1>
          <xsl:variable name="category" select="."/>
          <title><xsl:value-of select="$category"/></title>
          <xsl:for-each select="../../../recipe[categories/category[position()=1]=$category]/title">
            <xsl:sort/>
            <xsl:apply-templates select=".."/>
          </xsl:for-each>
        </sect1>
      </xsl:for-each>

    </article>

  </xsl:template>

  <xsl:template match="recipe">

    <sect2>

      <title><xsl:value-of select="title"/></title>

      <!-- Create category list. -->
      <sect3>
        <xsl:value-of select="document($lfile)/dictionary/entry[@text='Categories']"/>
        <xsl:text>: </xsl:text>

        <xsl:for-each select="categories/category">
          <xsl:value-of select="."/>
          <xsl:if test="not(position()=last())">, </xsl:if>          
        </xsl:for-each>

      </sect3>

      <!-- Information about recipe's yield. -->
      <sect3>
        <title>
          <xsl:value-of select="document($lfile)/dictionary/entry[@text='Yield']"/>
        </title>
        <para>
          <xsl:value-of select="servings/amount"/>
          <xsl:text> </xsl:text>
          <xsl:value-of select="servings/unit"/>
        </para>
      </sect3>

      <!-- List of ingredients. -->
      <sect3>
        <title>
          <xsl:value-of select="document($lfile)/dictionary/entry[@text='Ingredients']"/>
        </title>
        <informaltable rowsep="0" colsep="0">
          <tgroup cols="4">
            <colspec colname="amount"/>
            <colspec colname="unit"/>
            <colspec colname="name"/>
            <colspec colname="prep"/>
            <spanspec spanname="section" namest="amount" nameend="prep" align="left"/>
            <thead>
              <row>
                <entry><xsl:value-of select="document($lfile)/dictionary/entry[@text='Amount']"/></entry>
                <entry><xsl:value-of select="document($lfile)/dictionary/entry[@text='Unit']"/></entry>
                <entry><xsl:value-of select="document($lfile)/dictionary/entry[@text='Name']"/></entry>
                <entry><xsl:value-of select="document($lfile)/dictionary/entry[@text='Preparation']"/></entry>
              </row>
            </thead>
            <tbody>
              <xsl:for-each select="ingredients/section">
                <xsl:variable name="section" select="column[position()=1]"/>
                <xsl:if test="title">
                  <row>
                    <entry spanname="section" rowsep="1">
                      <xsl:value-of select="title"/>
                    </entry>
                  </row>
                </xsl:if>
                <xsl:for-each select="ingredient">
                  <row>
                    <xsl:if test="not(position()=last())">
                      <xsl:attribute name="rowsep">0</xsl:attribute>
                    </xsl:if>
                    <entry>
                      <xsl:if test="amount">
                        <xsl:choose>
                          <xsl:when test="amount/float">
                            <xsl:value-of select="amount/float"/>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:choose>
                              <xsl:when test="amount/fraction/nominator >= amount/fraction/denominator">
                                <xsl:value-of select="floor(amount/fraction/nominator div amount/fraction/denominator)"/>
                                <xsl:if test="amount/fraction/nominator mod amount/fraction/denominator > 0">
                                  <xsl:text> </xsl:text>
                                  <xsl:value-of select="amount/fraction/nominator mod amount/fraction/denominator"/>
                                  <xsl:text>/</xsl:text>
                                  <xsl:value-of select="amount/fraction/denominator"/>
                                </xsl:if>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:value-of select="amount/fraction/nominator"/>
                                <xsl:text>/</xsl:text>
                                <xsl:value-of select="amount/fraction/denominator"/>
                              </xsl:otherwise>
                            </xsl:choose>
                          </xsl:otherwise>
                        </xsl:choose>
                      </xsl:if>
                    </entry>
                    <entry>
                      <xsl:value-of select="unit"/>
                    </entry>
                    <entry>
                      <xsl:value-of select="name"/>
                    </entry>
                    <entry>
                      <xsl:value-of select="prep"/>
                    </entry>
                  </row>
                </xsl:for-each>
              </xsl:for-each>
            </tbody>
          </tgroup>
        </informaltable>
      </sect3>

      <!-- Instructions -->
      <sect3>
        <title>
          <xsl:value-of select="document($lfile)/dictionary/entry[@text='Preparation']"/>
        </title>
        <xsl:for-each select="instructions/section">
          <sect4>
            <title><xsl:value-of select="title"/></title>
            <xsl:for-each select="par">
              <para>
                <xsl:value-of select="."/>
              </para>
            </xsl:for-each>
          </sect4>
        </xsl:for-each>
      </sect3>

    </sect2>

  </xsl:template>

</xsl:stylesheet>
