// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "reportplugin.h"
#include <algorithm>
#include <fstream>

//#define DEBUG

reportPlugin::reportPlugin() :
		strPrefix( "report" ),
		strName( "Report Plugin" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "For all report parameters." )
{}

reportPlugin::~reportPlugin()
{}

void reportPlugin::beforeParam( void )
{
	std::list< Report * >::iterator i;
	std::string np;
	for ( i = maps.r->begin(); i != maps.r->end(); i++ )
	{
		np = ( *i ) ->Prefix();
		np += "-file";
		addParam( ( *i ) ->Prefix(), "Select this report.", "This is a flag.", FLAG, "0" );
		addParam( np.c_str(), "Write all output from this report to this file.",
		          "Path and Filename.", STRING, "" );
	}
	std::list< Analyse * >::iterator j;
	for ( j = maps.a->begin(); j != maps.a->end(); j++ )
	{
		addParam( ( *j ) ->Prefix(), "Change the Report for this Analyse only.",
		          "Select the Report.", STRING, "" );
	}
}

Plugin::ps_e reportPlugin::init( void )
{
	Report * r = 0;
	std::list< Report * >::iterator i;
	std::list< Analyse * >::iterator j;
	std::map< Report *, int >::iterator k;

	// Clear used Report list
	usedReports.clear();

	// Search for primary Report
	for ( i = maps.r->begin(); i != maps.r->end(); i++ )
	{
		if ( getFlagParam( ( *i ) ->Prefix() ) )
		{
			if ( r != 0 )
			{
				std::cerr << "You can't select two different reports!" << std::endl;
				return PS_STOP;
			}
			else
			{
				r = &( **i );
			}
		}
	}

	// Default Report selection.
	if ( r == 0 ) r = *maps.r->begin(); // no report set? select the default.
	for ( j = maps.a->begin(); j != maps.a->end(); j++ )
	{
		if ( ( *j ) ->getReport() == 0 ) ( *j ) ->setReport( r );
	}

	for ( j = maps.a->begin(); j != maps.a->end(); j++ )
	{
		std::string newr = getStringParam( ( *j ) ->Prefix() );
		if ( newr != "" )
		{
			std::string cur;
			for ( i = maps.r->begin(); i != maps.r->end(); i++ )
			{
				cur = ( *i ) ->Prefix();
				if ( cur == newr ) break;
			}
			if ( i == maps.r->end() )
			{
				std::cerr << "I don't know the report \"" << newr << "\", for \"" <<
				( *j ) ->Prefix() << "\"." << std::endl;
				return PS_STOP;
			}
			else
			{
				( *j ) ->setReport( &( **i ) );
			}
		}
	}

	// Checking for Redirections.
	for ( i = maps.r->begin(); i != maps.r->end(); i++ )
	{
		std::string rp = ( *i ) ->Prefix();
		rp += "-file";
		if ( getStringParam( rp ) != "" )
		{
			std::ofstream * fs = new std::ofstream( getStringParam( rp ).c_str() );
			if ( !( *fs ) )
			{
				std::cerr << "Can't open file \"" << getStringParam( rp ) << "\" for writing." << std::endl;
				return PS_STOP;
			}
#ifdef DEBUG
			std::cerr << "DEBUG: Open File \"" << getStringParam( rp ) << "\" for writing all output from "
			"Report \"" << ( *i ) ->Prefix() << "\"." << std::endl;
#endif
			( *i ) ->setOstream( fs ); // Set pointer to stream.
		}
		else
		{
			( *i ) ->setOstream( &std::cout ); // Set pointer to cout stream.
		}
	}

	// Scan for used Reports, and Print the Reportheader for this Reports.
	for ( j = maps.a->begin(); j != maps.a->end(); j++ )
	{
		usedReports[ ( *j ) ->getReport() ] ++;
	}

#ifdef DEBUG
	std::cerr << "DEBUG: " << usedReports.size() << " Report(s) are used." << std::endl;
#endif

	// Ok, send to every _used_ report the report page headers.
	for ( k = usedReports.begin(); k != usedReports.end(); k++ )
	{
#ifdef DEBUG
		std::cerr << "DEBUG: Report " << k->first->Prefix() << " is used " <<
		k->second << " time(s)." << std::endl;
		std::cerr << "DEBUG: Sending page header to the stream of this Report." << std::endl;
#endif
		k->first->printPageHeader();
	}

	return PS_ENABLE;
}

Plugin::ps_e reportPlugin::free( void )
{
	std::map< Report *, int >::iterator k;

	// Free open and used Filedescriptors
	for ( k = usedReports.begin(); k != usedReports.end(); k++ )
	{
#ifdef DEBUG
		std::cerr << "DEBUG: Sending page footer to stream of Report " << k->first->Prefix() << "." << std::endl;
#endif
		k->first->printPageFooter();
#ifdef DEBUG
		std::cerr << "DEBUG: Closing (delete) stream of Report " << k->first->Prefix() << "." << std::endl;
#endif
		if ( k->first->getOstream() != &std::cout ) delete k->first->getOstream();
	}

	return PS_CONTINUE;
}

// End of File
