//
// This file is part of the aMule Project.
//
// Copyright (c) 2003-2009 aMule Team ( admin@amule.org / http://www.amule.org )
// Copyright (c) 2002 Merkur ( devs@emule-project.net / http://www.emule-project.net )
//
// Any parts of this program derived from the xMule, lMule or eMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#ifndef KADCONSTANTS_H
#define KADCONSTANTS_H

#include <common/Macros.h>

// MOD Note: Do not change this part - Merkur

#define	KADEMLIAASKTIME			SEC2MS(1)	//1 second
#define	KADEMLIATOTALFILE		5		//Total files to search sources for.
// ADUNANZA BEGIN
#if 0
#define	KADEMLIAREASKTIME		HR2MS(1)	//1 hour
#else
#define KADEMLIAREASKTIME		MIN2MS(45)	// Mr Hyde KADU2 da 3.15b74 - prima: MIN2MS(3)
#endif
// ADUNANZA END

#define	KADEMLIAPUBLISHTIME		SEC(2)		//2 second
#define	KADEMLIATOTALSTORENOTES		1		//Total hashes to store.
// ADUNANZA BEGIN
#if 0
#define	KADEMLIATOTALSTORESRC		3		//Total hashes to store.
#define	KADEMLIATOTALSTOREKEY		2		//Total hashes to store.
#else
#define KADEMLIATOTALSTORESRC	        (18) // 3*6	//Total hashes to store. // Mr Hyde KADU2 da 3.15b74  - prima: 12 (2*6)
#define KADEMLIATOTALSTOREKEY	        (16) // 2*8	//Total hashes to store. // Mr Hyde KADU2 da 3.15b74  - prima:  3 (1*3) 
#endif
// ADUNANZA END
#define	KADEMLIAREPUBLISHTIMES		HR2S(5)		//5 hours
#define	KADEMLIAREPUBLISHTIMEN		HR2S(24)	//24 hours
#define	KADEMLIAREPUBLISHTIMEK		HR2S(24)	//24 hours
#define	KADEMLIADISCONNECTDELAY		MIN2S(20)	//20 mins
#define	KADEMLIAMAXINDEX		50000		//Total keyword indexes.
#define	KADEMLIAMAXENTRIES		60000		//Total keyword entries.
#define	KADEMLIAMAXSOURCEPERFILE	1000		//Max number of sources per file in index.
#define	KADEMLIAMAXNOTESPERFILE		150		//Max number of notes per entry in index.
// ADUNANZA BEGIN
#if 0
#define KADEMLIAFIREWALLCHECKS		4		//Firewallcheck Request at a time
#else
#    if !defined(ENABLE_ADUNSLU2)
#        define KADEMLIAFIREWALLCHECKS		4		//Firewallcheck Request at a time
#    else
#        define KADEMLIAFIREWALLCHECKS		6		//Firewallcheck Request at a time
#    endif
#endif
// ADUNANZA END
// MOD Note: end

// Kad parameters
#define	KADEMLIA_FIND_VALUE		0x02
#define	KADEMLIA_STORE			0x04
#define	KADEMLIA_FIND_NODE		0x0B

// AdunanzA Parameter
// Mr Hyde: TAG ET_SUPERADU spostata in include/tags/ClientTags.h
// #define ET_SUPERADU3                  0x60    // Adunanza HandShaking
#define ADU_SESSIONMAXTRANS           19503513.6f // = (18.6*1024*1024) Adunanza Expanded Chunks
#define ADU_FILEREASKTIME             MIN2MS(6)
// End AdunanzA Parameter
// Mr Hyde: le segg. copiate da eMule AdunanzA 3.15b74
#define SESSIONMAXTRANS               9751756.8f // = (9.3*1024*1024) = 9.3 Mbytes. "Try to send complete chunks" always sends this amount of data
// #define SESSIONMAXTRANS			(/*PARTSIZE+20*1024*/ 9748480) // "Try to send complete chunks" always sends this amount of data
#define	HR2MS(hr)		        MIN2MS((hr)*60)
#define SESSIONMAXTIME			HR2MS(1)	//1 hour


#define KADEMLIAFRESHGUESS_TOLERANCE 0.2f
#define KADEMLIAFRESHGUESS_WEIGHT 0.85f
#define KADEMLIAFRESHGUESS_LOWNORMSOURCES 16
#define KADEMLIAFRESHGUESS_NONORMSOURCES 8

// Valori prima di copia da eMule AdunanzA 3.15b74 
// #define KADEMLIAFRESHGUESS_TOLERANCE 0.25f
// #define KADEMLIAFRESHGUESS_WEIGHT 0.4f
// #define KADEMLIAFRESHGUESS_LOWNORMSOURCES 16
// #define KADEMLIAFRESHGUESS_NONORMSOURCES 8

// Fine
// ADUNANZA END



#endif // KADCONSTANTS_H
