<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN"
      "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
  <title>Amaya - Bienvenue</title>
  <link href="amaya.css" rel="stylesheet" type="text/css" />
</head>

<body xml:lang="fr">
<p><svg xmlns="http://www.w3.org/2000/svg" width="600" height="349">
  <defs>
    <symbol id="cube">
      <polygon points="0,0 5,5 5,20 0,15" transform="translate(0,1)"
               stroke-width="1"/>
      <polygon points="0,0 15,0 20,5 5,5" transform="translate(1,0)"
               stroke-width="1"/>
      <rect x="6" y="6" width="15" height="15" stroke-width="1"/>
    </symbol>
  </defs>
  <rect x="464" y="4" width="138" height="330" style="fill: #E1E1E1"/>
  <g style="fill:#dc5b53; font: bold 16px" transform="translate(477,0)">
    <a xlink:href="http://www.w3.org/Amaya">
      <text y="38px" x="0px">Amaya au W3C
      </text>
    </a>
    <a xlink:href="../doc/html/Tutorial.html.fr">
      <text y="68px" x="0px">Guide
      </text>
    </a>
    <a xlink:href="../doc/html/Index.html.fr">
      <text y="98px" x="3px">Index
      </text>
    </a>
    <a xlink:href="../doc/html/Annotations.html.fr">
      <text y="128px" x="0px">Annotations
      </text>
    </a>
    <a xlink:href="../doc/html/Creating.html.fr">
      <text y="158px" x="0px">XHTML
      </text>
    </a>
    <a xlink:href="../doc/html/Math.html.fr">
      <text y="188px" x="0px">MathML
      </text>
    </a>
    <a xlink:href="../doc/html/SVG.html.fr">
      <text y="218px" x="0px">SVG
      </text>
    </a>
    <a xlink:href="../doc/html/StyleSheets.html.fr">
      <text y="248px" x="0px">CSS
      </text>
    </a>
    <a xlink:href="http://www.w3.org">
      <image xlink:href="../doc/images/w3c_home" y="278px" x="0px">
        <desc>W3C</desc>
      </image>
    </a>
  </g>
  <g transform="translate(2,2)">
    <image id="backgroundImage" x="0" y="0" width="466" height="349"
           xlink:href="amaya.png">
      <desc>Leading the Web to its full potential</desc>
    </image>
    <g id="cubes">
      <use x="200" y="112" xlink:href="#cube" style="fill: #0192BF"/>
      <use x="230" y="112" xlink:href="#cube" style="fill: #2B9FC3"/>
      <use x="260" y="112" xlink:href="#cube" style="fill: #53AAC5"/>
      <use x="290" y="112" xlink:href="#cube" style="fill: #7AB4C6"/>
      <use x="320" y="112" xlink:href="#cube" style="fill: #A3C0C9"/>
      <use x="350" y="112" xlink:href="#cube" style="fill: #A3C0C9"/>
      <use x="380" y="112" xlink:href="#cube" style="fill: #A3C0C9"/>
      <use x="410" y="112" xlink:href="#cube" style="fill: #EC1608"/>
      <use x="410" y="142" xlink:href="#cube" style="fill: #E2372C"/>
      <use x="350" y="172" xlink:href="#cube" style="fill: #DAAFAC"/>
      <use x="380" y="172" xlink:href="#cube" style="fill: #DF8984"/>
      <use x="410" y="172" xlink:href="#cube" style="fill: #DC5B53"/>
    </g>
    <text id="logo" x="304" y="162"
          style="font: 24px helvetica; font-weight: bold; fill: #488B9B;">AMAYA 
      <animateTransform attributeName="transform" attributeType="XML"
                        type="translate" from="-304,-162" to="0,0" begin="0s"
                        dur="6s" fill="freeze"/>
    </text>
    <g id="polygonMask" style="stroke: none;">
      <polygon style="fill: #0192BF;" points="0,0 0,170 78,148"
               transform="translate(30,60)" stroke-width="1" opacity="1"/>
      <polygon style="fill: #9EA4A6;" points="0,0 78,148 95,95"
               transform="translate(30,60)scale(1.000000,1.000000)"
               stroke-width="1" opacity=".8"/>
      <polygon style="fill: #89A5C7;" points="0,0 95,95 114,101"
               transform="translate(30,60)scale(1.000000,1.000000)"
               stroke-width="1" opacity=".9"/>
      <polygon style="fill: #488B9B;" points="0,0 114,101 108,55"
               transform="translate(30,60)scale(1.000000,1.000000)"
               stroke-width="1" opacity="0.6"/>
      <polygon style="fill: #9EA4A6;" points="0,0 108,55 150,54"
               transform="translate(30,60)scale(1.000000,1.000000)"
               stroke-width="1" opacity="0.4"/>
      <polygon style="fill: #EC1608;" points="0,0 150,54 130,0"
               transform="translate(30,60)scale(1.000000,1.000000)"
               stroke-width="1" opacity="0.2"/>
      <switch>
        <foreignObject y="156px" x="35px">
          xmlns="http://www.w3.org/1999/xhtml" <math
          xmlns="http://www.w3.org/1998/Math/MathML"
          style="color: #FFFFFF; font-family: times">
            <mrow>
              <mi>y</mi>
              <mo>=</mo>
              <mfrac>
                <mn>1</mn>
                <msqrt>
                  <mrow>
                    <msup>
                      <mi>x</mi>
                      <mn>2</mn>
                    </msup>
                    <mo>+</mo>
                    <mn>1</mn>
                  </mrow>
                </msqrt>
              </mfrac>
            </mrow>
          </math></foreignObject>
      </switch>
    </g>
  </g>
</svg>
</p>

<div>
<h3>Amaya</h3>

<p><strong>Amaya</strong> est un client Web qui sert  la fois de navigateur
et d'outil d'dition. Il a t conu par le <a
href="http://www.w3.org/">W3C</a> avec pour but essentiel la dmonstration
des nouvelles technologies Web dans un environnement WYSIWYG (What You See Is
What You Get). La version courante supporte les recommandations HTML
(Hypertext Markup Language), XHTML (Extensible Hypertext Markup Language),
MathML (Mathematical Markup Language), SVG (Scalable Vector Graphics), CSS
(Cascading Style Sheets), et HTTP (Hypertext Transfer Protocol).</p>
</div>

<div>

<div>
<h3>Caractristiques principales</h3>

<p>Avec Amaya, vous pouvez manipuler des pages Web contenant des formulaires,
des tables et les caractristiques les plus avances de HTML. Vous pouvez
crer et diter des <a href="../doc/html/Math.html.fr">expressions
mathmatiques</a> complexes et des <a
href="../doc/html/SVG.html.fr">graphiques SVG</a> dans les pages Web. Vous
pouvez styler vos documents en utilisant les cascades de feuilles de style
(CSS). Vous pouvez publier des documents HTML, XHTML, MathML et SVG sur un
serveur local ou distant  travers HTTP. Un support pour le XML gnrique est
galement disponible vous permettant de visualiser le contenu de n'importe
quel document et de lui associer une feuille de style CSS.</p>

<p>La navigation et l'dition sont intimement intgres. Vous pouvez naviguer
et diter des pages Web en mme temps. Pour rendre l'dition plus aise, un
simple clic dans Amaya change seulement le point d'insertion et permet de
rentrer le texte; pour suivre un lien, vous devez double-cliquer. Ce
comportement peut tre modifi ainsi que de nombreuses caractristiques en
utilisant le menu dition/Prfrences.</p>

<p>Amaya inclut une application <a
href="../doc/html/Annotations.html.fr"><img src="annot.gif"
alt="Icone d'annotation" />d'annotations collaboratives</a> base sur les
technologies du W3C (RDF, XLink et XPointer). Les annotations sont des
commentaires, notes, remarques externes qui peuvent tre attaches  un
document Web complet ou  n'importe quelle partie slectionne d'un document.
Les annotations sont stockes soit sur la machine locale, soit dans des
serveurs d'annotation. La cration d'annotations sur un document ne modifie
pas le document lui-mme.</p>

<p>Une vue source montre le balisage courant produit par Amaya. En utilisant
cette vue en parallle avec la vue principale, vous pouvez travailler sur la
page prsente et sur le code source.</p>
</div>

<div>
<h3>Manuel en ligne</h3>

<p>Un manuel d'utilisation est disponible en ligne. Vous pouvez y accder
avec le menu Aide, qui affiche chaque section sparment. Vous pouvez
galement l'imprimer: il suffit de suivre le lien <a
href="../doc/html/Manual.html.fr">Manuel en ligne</a>. Vous obtiendrez la
page de garde. Construisez ensuite le livre entier  l'aide de l'entre
"Construire un livre" du menu XHTML et imprimez le rsultat.</p>
</div>

<div>
<h3>Droit de copie</h3>

<p>Il est permis d'utiliser, de copier, de modifier et de distribuer ce
logiciel et sa documentation dans n'importe quel but et sans rtribution ou
droits d'auteur, pourvu que tout le texte de <a
href="http://www.w3.org/Consortium/Legal/copyright-software.html">dclaration
du droit de copie du MIT et de l'INRIA</a> apparaisse sur TOUTES les copies
du logiciel et de sa documentation ou portions de celle-ci, incluant les
modifications que vous effectuez.</p>
</div>
</div>
</body>
</html>
