/* $Id: wmrc.c,v 1.20 2000/11/11 23:41:54 komatsu Exp $ */

/* XML եޥåȤΥޥѥեɤ߹. 
 * XML Ϥ˱ä.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include "wmrc.h"
#include "wmmain.h"
#include "wmmisc.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <parser.h> /* For gnome-xml */
/* ηٹϤɤΤ... 
/usr/include/gnome-xml/tree.h:444: warning: declaration of `root' shadows global declaration
*/

static WmRcFrame
*wm_rc_parse_frame(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur);
static WmRcWindow
*wm_rc_parse_window(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur);
static WmRcMenu
*wm_rc_parse_menu(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur);
static WmLabelList
*wm_rc_parse_label(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur);

gint wm_rc_parse_menu_get_type(const gchar *type);
static void wm_rc_set_default(void);

void wm_rc_parser_error(void *ctx, const char *msg, ...);
void wm_rc_parser_warning(void *ctx, const char *msg, ...);
gchar *wm_rc_parser_print_file_info(xmlParserInputPtr input);
gchar *wm_rc_parser_print_file_context(xmlParserInputPtr input);

static GData *system_funcs = NULL;
static GData *menus   = NULL;
static GData *windows = NULL;
static GData *frames  = NULL;

static WmRcWindow *default_rc_window;

WmRc *wm_rc_init(gchar *filename)
{
    xmlDocPtr  doc;
    xmlNodePtr cur;
    xmlNsPtr   ns;
    xmlChar   *key;

    WmRc     *wm_rc;

    wm_rc_set_default();
    xmlDefaultSAXHandler.warning    = wm_rc_parser_warning;
    xmlDefaultSAXHandler.error      = wm_rc_parser_error;
    xmlDefaultSAXHandler.fatalError = wm_rc_parser_error;

/*     rc_error = g_strdup(""); */
    doc = xmlParseFile(filename);
/*     if (*rc_error != '\0') { wm_alert(".amaterus error", rc_error); } */
    if (doc == NULL) {
	wm_message("WM_RC: File %s is not found.\n", filename);
	return NULL;
    }

    cur = doc->root;
    if (cur == NULL) {
	wm_message("WM_RC: File %s is empty data.\n", filename);
	xmlFreeDoc(doc);
	return NULL;
    }

    ns = NULL;

    if (strcmp(cur->name, "WMRC")) {
	wm_message("WM_RC: File %s is not WMRC file.\n", filename);
	xmlFreeDoc(doc);
	return NULL;
    }

    wm_rc = g_malloc(sizeof (WmRc));

    cur = cur->childs;
    while (cur) {
	if (!strcmp(cur->name, "menu") && cur->ns == ns) {
	    key = xmlGetProp(cur, "id");
	    g_datalist_set_data(&menus, key, 
				(gpointer)wm_rc_parse_menu(doc, ns, cur));
	    free(key);

	} else if (!strcmp(cur->name, "window") && cur->ns == ns) {
	    key = xmlGetProp(cur, "class");
	    g_datalist_set_data(&windows, key, 
				(gpointer)wm_rc_parse_window(doc, ns, cur));
	    free(key);

	} else if (!strcmp(cur->name, "frame") && cur->ns == ns) {
	    key = xmlGetProp(cur, "name");
	    g_datalist_set_data(&frames, key, 
				(gpointer)wm_rc_parse_frame(doc, ns, cur));
	    free(key);
	}
	cur = cur->next;
    }
    wm_rc->menus = menus;
    
    return wm_rc;
}

void wm_rc_set_default(void)
{
    default_rc_window = g_malloc(sizeof (WmRcWindow));
    default_rc_window->border = g_malloc(sizeof (WmRcWindowBorder));
    default_rc_window->border->width = 3;
    default_rc_window->border->frame = "default";
    default_rc_window->geometry = g_malloc(sizeof (WmRcWindowGeometry));
    default_rc_window->geometry->flags = 0;
    default_rc_window->title = g_malloc(sizeof (WmRcWindowTitle));
    default_rc_window->title->format = "$t";
}

WmRcWindow *wm_rc_parse_window(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
    WmRcWindow         *window;
    WmRcWindowBorder   *border;
    WmRcWindowGeometry *geometry;
    WmRcWindowTitle    *title;

    wm_message("WmRc: wm_rc_parse_window\n");

    window = g_malloc(sizeof (WmRcWindow));
    window->class  = xmlGetProp(cur, "class");
    window->border   = default_rc_window->border;
    window->geometry = default_rc_window->geometry;
    window->title    = default_rc_window->title;

    cur = cur->childs;
    while (cur) {
	if (!strcmp(cur->name, "border") && cur->ns == ns) {
	    xmlChar *width, *frame;
	    border = g_malloc(sizeof (WmRcWindowBorder));

	    width = xmlGetProp(cur, "width");
	    if (width) {
		border->width = atoi(width);
		free(width);
	    } else {
		border->width = default_rc_window->border->width;
	    }
	    
	    frame = xmlGetProp(cur, "frame");
	    if (frame) {
		border->frame = frame;
	    } else {
		border->frame = default_rc_window->border->frame;
	    }
	    window->border = border;
	} else if (!strcmp(cur->name, "geometry") && cur->ns == ns) {
	    xmlChar *x, *y;
	    geometry = g_malloc(sizeof (WmRcWindowGeometry));
	    geometry->flags = 0;

	    x = xmlGetProp(cur, "x");
	    if (x) {
		geometry->x = atoi(x);
		/* '-0' б뤿 '-0'  -1 Ѥ. */
		if (*x == '-') { 
		    (geometry->x)--;
		}
		geometry->flags |= RC_WINDOW_GEOMETRY_X;
		free(x);
	    }

	    y = xmlGetProp(cur, "y");
	    if (y) {
		geometry->y = atoi(y);
		if (*y == '-') { 
		    (geometry->y)--;
		}
		geometry->flags |= RC_WINDOW_GEOMETRY_Y;
		free(y);
	    }
	    window->geometry = geometry;
	} else if (!strcmp(cur->name, "title") && cur->ns == ns) {
	    xmlChar *format;
	    title = g_malloc(sizeof (WmRcWindowTitle));

	    format = xmlGetProp(cur, "format");
	    if (format) { 
		title->format = format;
	    } else {
		title->format = default_rc_window->title->format;
	    }
	    window->title = title;
	}
	cur = cur->next;
    }
    return window;
}

WmRcMenu *wm_rc_parse_menu(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
    WmRcMenu *menu, *menu_old;
    WmRcMenuItem *item;
    
    menu = g_malloc(sizeof (WmRcMenu));
    menu->id     = xmlGetProp(cur, "id");
    menu->title  = xmlGetProp(cur, "title");
    menu->item   = NULL;
/*     menu->widget = gtk_menu_new(); */
    menu->widget = NULL;

    menu_old = g_datalist_get_data(&menus, menu->id);
    if (menu_old) {
	g_free(menu_old);
    }

    cur = cur->childs;
    while (cur) {
	if (!strcmp(cur->name, "item") && cur->ns == ns) {
	    xmlChar *type;

	    item = g_malloc(sizeof (WmRcMenuItem));

	    type       = xmlGetProp(cur, "type");
	    item->type = wm_rc_parse_menu_get_type(type);
	    free(type);
	    if (item->type) {
		item->title   = wm_rc_parse_label(doc, ns, cur->childs);
		item->command = xmlGetProp(cur, "command");
		menu->item = g_list_append(menu->item, item);
	    } else {
		g_free(item);
	    }
	} else if (!strcmp(cur->name, "hr") && cur->ns == ns) {
	    item = g_malloc(sizeof (WmRcMenuItem));
	    item->type    = RC_MENU_HR;
	    item->title   = NULL;
	    item->command = NULL;
	    menu->item = g_list_append(menu->item, item);
	} else if (!strcmp(cur->name, "menu") && cur->ns == ns) {
	    item = g_malloc(sizeof (WmRcMenuItem));
	    item->type    = RC_MENU_MENU;
	    item->title   = 
		wm_label_list_new_with_string(xmlGetProp(cur, "title"));
	    item->command = xmlGetProp(cur, "id");
	    menu->item = g_list_append(menu->item, item);
	    g_datalist_set_data(&menus, item->command, 
				(gpointer)wm_rc_parse_menu(doc, ns, cur));
	}
	cur = cur->next;
    }
    return menu;
}

WmLabelList *wm_rc_parse_label(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
    WmLabelList *label_list = NULL;
    WmLabelItem *label;

    wm_message("wm_rc_parse_label\n");
    while (cur) {
	switch (cur->type) {
	case XML_TEXT_NODE:
	    wm_message("wm_rc_parse_label <TEXT>\n");
	    label = wm_label_item_new(WM_LABEL_TEXT, 
				      (gpointer)xmlNodeGetContent(cur));
	    break;
	    
	case XML_ELEMENT_NODE:
	    wm_message("wm_rc_parse_label <IMG>\n");
	    /* IMG ǤʤΤϥ */
	    label = wm_label_item_new(WM_LABEL_IMG, 
				      xmlGetProp(cur, "src"));
	    break;

	default:
	    wm_message("wm_rc_parse_label <UNKNOWN>\n");
	    label = wm_label_item_new(WM_LABEL_UNKOWN, NULL);
	}
	label_list = g_list_append(label_list, label);
	cur = cur->next;
    }
    return label_list;
}



WmRcFrame *wm_rc_parse_frame(xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
    WmRcFrame *frame;
    WmRcFrameWidget *widget;
    xmlChar *pack;

    frame = g_malloc(sizeof (WmRcFrame));
    frame->name   = xmlGetProp(cur, "name");
    frame->widget = NULL;
    frame->pack = RC_FRAME_PACK_H;
    if ((pack = xmlGetProp(cur, "pack"))) {
	if (!strcmp(pack, "vertical")) {
	    frame->pack = RC_FRAME_PACK_V;
	}
	free(pack);
    }
	
    cur = cur->childs;
    while (cur) {
	if (!strcmp(cur->name, "widget") && cur->ns == ns) {
	    widget = g_malloc(sizeof (WmRcFrameWidget));
	    widget->type = xmlGetProp(cur, "type");
	    if (widget->type) {
		widget->ref = xmlGetProp(cur, "ref");
		frame->widget = g_list_append(frame->widget, widget);
	    } else {
		g_free(widget);
	    }
	} else if (!strcmp(cur->name, "frame") && cur->ns == ns) {
	    xmlChar *key;
	    key = xmlGetProp(cur, "name");
	    g_datalist_set_data(&frames, key, 
				(gpointer)wm_rc_parse_frame(doc, ns, cur));

	    widget = g_malloc(sizeof (WmRcFrameWidget));
	    widget->type = g_strdup("frame");
	    widget->ref  = key;
	    frame->widget = g_list_append(frame->widget, widget);
	}
	cur = cur->next;
    }
    return frame;
}

gint wm_rc_parse_menu_get_type(const gchar *type) 
{
    if (!type) {
	return RC_MENU_EMPTY;
    } else if (!strcmp(type, "exit")) {
	return RC_MENU_EXIT;
    } else if (!strcmp(type, "restart")) {
	return RC_MENU_RESTART;
    } else if (!strcmp(type, "system")) {
	return RC_MENU_SYSTEM;
    } else if (!strcmp(type, "exec")) {
	return RC_MENU_EXEC;
    } else if (!strcmp(type, "menu")) {
	return RC_MENU_MENU;
    }
    return RC_MENU_EMPTY;
}

void wm_rc_system_set_func(GtkSignalFunc func, const gchar *id)
{
    g_datalist_set_data(&system_funcs, id, func);
}

GtkSignalFunc wm_rc_system_get_func(gchar *id)
{
    return g_datalist_get_data(&system_funcs, id);
}

WmRcWindow *wm_rc_window_get(gchar *id)
{
    WmRcWindow *rc;

    /* id μϻˡ */
    wm_message("WmRc: wm_rc_window_get[%s]\n", id);
    rc = g_datalist_get_data(&windows, id);
    if (rc) {
	return rc;
    } else {
	return default_rc_window;
    }
}

WmRcFrame *wm_rc_frame_get(gchar *name)
{
    return g_datalist_get_data(&frames, name);
}

/* This function was made by modifying xmlParserError. */
void wm_rc_parser_error(void *ctx, const char *msg, ...)
{
    xmlParserCtxtPtr  ctxt = (xmlParserCtxtPtr) ctx;
    xmlParserInputPtr input;
    xmlParserInputPtr cur = NULL;
    va_list args;
    gchar *message, *rc_error_old, *info1, *info2, *context1, *context2;

    input = ctxt->input;
    if ((input != NULL) && (input->filename == NULL) && (ctxt->inputNr > 1)) {
	cur   = input;
        input = ctxt->inputTab[ctxt->inputNr - 2];
    }
        
    info1 = wm_rc_parser_print_file_info(input);

    va_start(args, msg);
    message = g_strdup_vprintf(msg, args);
    va_end(args);

    context1     = wm_rc_parser_print_file_context(input);
    rc_error_old = rc_error;
    rc_error     = 
	g_strconcat(rc_error_old, info1, "error: ", message, context1, NULL);

    if (cur != NULL) {
        info2    = wm_rc_parser_print_file_info(cur);
	context2 = wm_rc_parser_print_file_context(cur);
	g_free(rc_error_old);
	rc_error_old = rc_error;
	rc_error     = g_strconcat(rc_error_old, info2, "\n", context2, NULL);
	g_free(info2);
	g_free(context2);
    }
    g_free(rc_error_old);
    g_free(message);
    g_free(info1);
    g_free(context1);
}

/* This function was made by modifying xmlParserWarning. */
/* wm_rc_parser_error ȰˤȤ. */
void wm_rc_parser_warning(void *ctx, const char *msg, ...)
{
    xmlParserCtxtPtr  ctxt = (xmlParserCtxtPtr) ctx;
    xmlParserInputPtr input;
    xmlParserInputPtr cur = NULL;
    va_list args;
    gchar *message, *rc_error_old, *info1, *info2, *context1, *context2;

    input = ctxt->input;
    if ((input != NULL) && (input->filename == NULL) && (ctxt->inputNr > 1)) {
	cur   = input;
        input = ctxt->inputTab[ctxt->inputNr - 2];
    }
        
    info1 = wm_rc_parser_print_file_info(input);

    va_start(args, msg);
    message = g_strdup_vprintf(msg, args);
    va_end(args);

    context1     = wm_rc_parser_print_file_context(input);
    rc_error_old = rc_error;
    rc_error     = 
	g_strconcat(rc_error_old, info1, "warning: ", message, context1, NULL);

    if (cur != NULL) {
        info2    = wm_rc_parser_print_file_info(cur);
	context2 = wm_rc_parser_print_file_context(cur);
	g_free(rc_error_old);
	rc_error_old = rc_error;
	rc_error     = g_strconcat(rc_error_old, info2, "\n", context2, NULL);
	g_free(info2);
	g_free(context2);
    }
    g_free(rc_error_old);
    g_free(message);
    g_free(info1);
    g_free(context1);
}

/* This function was made by modifying xmlParserPrintFileInfo. */
gchar *wm_rc_parser_print_file_info(xmlParserInputPtr input)
{
    gchar *file_info;
    if (input != NULL) {
        if (input->filename) {
	    file_info = 
		g_strdup_printf("%s:%d: ", input->filename, input->line);
	} else {
	    file_info = 
		g_strdup_printf("Entity: line %d: ", input->line);
	}
	return file_info;
    }
    return g_strdup("");
}

/* This function was made by modifying xmlParserPrintContext. */
gchar *wm_rc_parser_print_file_context(xmlParserInputPtr input)
{
    const xmlChar *cur, *base;
    int n;
    gchar strbuf1[80], strbuf2[80];

    if (input == NULL) { return g_strdup(""); }
    cur  = input->cur;
    base = input->base;

    while ((cur > base) && ((*cur == '\n') || (*cur == '\r'))) {
	cur--;
    }

    n = 0;
    while ((n++ < 80) && (cur > base) && (*cur != '\n') && (*cur != '\r')) {
        cur--;
    }
    if ((*cur == '\n') || (*cur == '\r')) { cur++; } 
    base = cur;

    n = 0;
    while ((*cur != 0) && (*cur != '\n') && (*cur != '\r') && (n < 79)) {
	strbuf1[n] = (unsigned char) *cur;
	cur++;
	n++;
    }
    strbuf1[n] = '\0';

    cur = input->cur;
    while ((*cur == '\n') || (*cur == '\r')) {
	cur--;
    }

    n = 0;
    while ((cur != base) && (n < 79)) {
	strbuf2[n] = ' ';
        base++;
	n++;
    }
    strbuf2[n] = '\0';

    return g_strconcat(strbuf1, "\n", strbuf2, "^\n", NULL);
}

#if 0
void wm_rc_test(void)
{
    WmRc *wmrc;
    WmRcMenu *menu;
    GList *list;
    WmRcMenuItem *item;
    wmrc = wm_rc_init(AMATERUSRC);
    menu = g_datalist_get_data(&(wmrc->menus), "menu_main");
    printf("id:%s, title:%s\n", menu->id, menu->title);

    for (list = menu->item; list; list = list->next) {
	item = list->data;
	printf("type:%d, cmd:%s, title:%s\n",
	       item->type, item->command, item->title);
    }
}

int main(int argc, char **argv)
{
    wm_rc_test();
}

/* ǥХåѴؿ */
void wm_message(const gchar *format, ...)
{
    va_list args;
    
    va_start(args, format);
    vfprintf(stderr, format, args);
    va_end(args);
    fflush(stderr);
}
#endif


	
