/* $Id: wmbasewindow.c,v 1.19 2000/07/25 09:03:52 komatsu Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <gtk/gtk.h>
#include <X11/Xlib.h>  /* For XShape */
#include <X11/Xutil.h> /* For XShape */
#include <X11/extensions/shape.h> /* For XShape */
#include "wmmain.h"
#include "wmbasewindow.h"
#include "wmclient.h"
#include "wmdrag.h"


static gint wm_basewindow_destroy(GtkWidget *widget, 
				  GdkEventAny *event, gpointer data);
static void wm_basewindow_realize(GtkWidget *widget, gpointer data);
static void wm_basewindow_set_shape(GtkWidget *widget, gpointer data);
static GdkFilterReturn wm_basewindow_anyevent_filter(GdkXEvent *xev, 
						     GdkEvent *event,
						     gpointer cb_data);


static void wm_basewindow_realize(GtkWidget *widget, gpointer data)
{
    XWindowAttributes    xwa;
    XSetWindowAttributes xswa;

    /* GNOME ڡ 饤ȤǤϤʤ WM ̾ɽƤޤ
       , WM Ȥ GTK ꤵ줿ץѥƥõƤ.
       GNOME (ڡ)  WM_HINTS ץѥƥ̵ͭǥ饤Ȥ
       ɤȽǤƤ餷.
       xprop Ʊ, XmuClientWindow Ȥäߤ. */
    /* оˡʤΤ, ŪˤϤʤʤ뤫Τʤ */
    XDeleteProperty(GDK_DISPLAY(), WM_XWINDOW(widget), wm_atom_wm_hints);

    XGetWindowAttributes(GDK_DISPLAY(), WM_XWINDOW(widget), &xwa);
    xswa.event_mask = xwa.all_event_masks 
	| StructureNotifyMask
/* 	| SubstructureNotifyMask */
	| SubstructureRedirectMask
	| 0;
    xswa.do_not_propagate_mask = xwa.do_not_propagate_mask
	| ButtonPressMask
	| ButtonReleaseMask
	| PointerMotionMask
	| 0;
    XChangeWindowAttributes(GDK_DISPLAY(), WM_XWINDOW(widget),
			    CWEventMask | CWDontPropagate, &xswa);

    gdk_window_add_filter(widget->window, wm_basewindow_anyevent_filter, data);
}

static void wm_basewindow_set_shape(GtkWidget *widget, gpointer data)
{
    GtkWidget *base;
    XRectangle rect[4];
    int xws, yws, xbs, ybs;
    int has_frame;
    unsigned wws, hws, wbs, hbs;
    int boundingShaped, clipShaped;

    base = gtk_widget_get_toplevel(GTK_WIDGET(data));
    XShapeQueryExtents (GDK_DISPLAY(), WM_CLIENT_XWINDOW(data),
			&boundingShaped, &xws, &yws, &wws, &hws,
			&clipShaped, &xbs, &ybs, &wbs, &hbs);
    if(!boundingShaped) { return; }

    XShapeCombineShape(GDK_DISPLAY(), WM_XWINDOW(base), ShapeBounding,
		       GTK_WIDGET(data)->allocation.x,
		       GTK_WIDGET(data)->allocation.y,
		       WM_CLIENT_XWINDOW(data),
		       ShapeBounding, ShapeSet);
    rect[0].x = 0;
    rect[0].y = 0;
    rect[0].width  = base->allocation.width;
    rect[0].height = GTK_WIDGET(data)->allocation.y;
    has_frame = rect[0].width * rect[0].height;

    rect[1].x = 0;
    rect[1].y = GTK_WIDGET(data)->allocation.y + WM_CLIENT_HEIGHT(data);
    rect[1].width  = base->allocation.width;
    rect[1].height = base->allocation.height - rect[1].y;
    has_frame += rect[1].width * rect[1].height;

    rect[2].x = 0;
    rect[2].y = GTK_WIDGET(data)->allocation.y;
    rect[2].width  = GTK_WIDGET(data)->allocation.x;
    rect[2].height = WM_CLIENT_HEIGHT(data);
    has_frame += rect[2].width * rect[2].height;

    rect[3].x = GTK_WIDGET(data)->allocation.x + WM_CLIENT_WIDTH(data);
    rect[3].y = GTK_WIDGET(data)->allocation.y;
    rect[3].width  = base->allocation.width - rect[3].x;
    rect[3].height = WM_CLIENT_HEIGHT(data);
    has_frame += rect[3].width * rect[3].height;

    /* ե졼बʤȤϽФ */
    if (has_frame) {
	XShapeCombineRectangles(GDK_DISPLAY(), WM_XWINDOW(base), ShapeBounding,
				0, 0, rect, 4, ShapeUnion, Unsorted);
    }
}

GtkWidget *wm_basewindow_new_default(GtkWidget *client)
{
    GtkWidget *base;

    base = wm_basewindow_new(client);
    gtk_container_border_width(GTK_CONTAINER(base), 
			       WM_CLIENT_BORDER_WIDTH(client));
    if(IS_WM_CLIENT(client)) {
	/* 饤Ȥ WmClient λɥΰ֤Ĵ */
	gtk_widget_set_uposition(base, 
				 WM_CLIENT_X(client), WM_CLIENT_Y(client));
    }
    return base;
}
    
static gint wm_basewindow_destroy(GtkWidget *widget, 
				  GdkEventAny *event, gpointer data)
{
    wm_message("WmBasewindow: window destroy\n");
    return FALSE;
}

GtkWidget *wm_basewindow_new(GtkWidget *client)
{
    GtkWidget *base;

    wm_message("WmBasewindow: new\n");

    base = gtk_window_new(GTK_WINDOW_TOPLEVEL);
    GTK_WINDOW(base)->auto_shrink = TRUE;

    gtk_signal_connect(GTK_OBJECT(base), "realize",
		       GTK_SIGNAL_FUNC(wm_basewindow_realize),
		       (gpointer)client);
    gtk_signal_connect(GTK_OBJECT(base), "realize",
		       GTK_SIGNAL_FUNC(wm_basewindow_set_shape),
		       (gpointer)client);
    gtk_signal_connect(GTK_OBJECT(client), "shape", /* äȵư԰ */
		       GTK_SIGNAL_FUNC(wm_basewindow_set_shape),
		       (gpointer)client);
    gtk_signal_connect(GTK_OBJECT(base), "destroy_event",
		       GTK_SIGNAL_FUNC(wm_basewindow_destroy), NULL);
    gtk_signal_connect(GTK_OBJECT(base), "delete_event",
		       GTK_SIGNAL_FUNC(wm_basewindow_destroy), NULL);
    return base;
}

/* ConfigureRequest, MapRequest ե륿ؿ */
static GdkFilterReturn wm_basewindow_anyevent_filter(GdkXEvent *xev, 
						     GdkEvent *event,
						     gpointer data)
{
    GdkFilterReturn return_value;
    XEvent         *xevent;

    return_value = GDK_FILTER_CONTINUE;
    xevent = (XEvent *)xev;

    switch(xevent->xany.type) {
    case ConfigureRequest:
	wm_message("WmBasewindow: Event - ConfigureRequest\n");
	wm_message("(%d, %d) %d x %d | %d\n",
		   xevent->xconfigurerequest.x,
		   xevent->xconfigurerequest.y, 
		   xevent->xconfigurerequest.width,
		   xevent->xconfigurerequest.height,
		   xevent->xconfigurerequest.value_mask);
	if(xevent->xconfigurerequest.value_mask & CWX) {
	    WM_CLIENT_X(data) = xevent->xconfigurerequest.x;
	}
	if(xevent->xconfigurerequest.value_mask & CWY) {
	    WM_CLIENT_Y(data) = xevent->xconfigurerequest.y;
	}
	if(xevent->xconfigurerequest.value_mask & (CWX | CWY)) {
	    XMoveWindow(GDK_DISPLAY(), 
			WM_XWINDOW(gtk_widget_get_toplevel(data)),
			WM_CLIENT_X(data), WM_CLIENT_Y(data));
	}
	if(xevent->xconfigurerequest.value_mask & CWWidth) {
	    WM_CLIENT_WIDTH(data)  = xevent->xconfigurerequest.width;
	}
	if(xevent->xconfigurerequest.value_mask & CWHeight) {
	    WM_CLIENT_HEIGHT(data) = xevent->xconfigurerequest.height;
	}
	if(xevent->xconfigurerequest.value_mask & (CWWidth | CWHeight)) {
	    gtk_widget_set_usize(data,
				 WM_CLIENT_WIDTH(data),
				 WM_CLIENT_HEIGHT(data));
	}
	return_value = GDK_FILTER_REMOVE;
	break;
    }
    return return_value;
}
