<!--
	Alcove book-like stylesheet for DocBook articles.

	Please refer to this stylesheet using the following public ID:

		-//Alcove//DOCUMENT DocBook Book-like Article Print Stylesheet//EN
-->

<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY parent.dsl PUBLIC "-//Alcove//DOCUMENT DocBook Extended Print Stylesheet//EN" CDATA dsssl>
]>
<style-sheet>
  <style-specification id="print" use="parent">
    <style-specification-body> 
;;
;; Generic layout
;;

(define %paper-type% "A4")
(define %left-margin% 2cm)		; 6pi
(define %right-margin% 2cm)		; 6pi
(define %top-margin% 2.5cm)		; 6pi
(define %bottom-margin% 2.5cm)		; 8pi
(define %header-margin% 1cm)		; 4pi

(define %section-autolabel% #t)
(define %default-quadding% 'justify)

;; only arabic page numbers, even on ToC pages
(define ($page-number-format$ #!optional (gi (gi)))
	"1")

;;
;; titlepage
;;

(define %generate-article-titlepage% #t)
(define %generate-article-titlepage-on-separate-page% #t)

;; what we want on titlepage
(define (article-titlepage-recto-elements)
  (list
;   (normalize "mediaobject")
   (normalize "title")
   (normalize "contractsponsor")
   (normalize "subtitle")
   (normalize "corpauthor")
   (normalize "address")
   (normalize "authorgroup")
   (normalize "author")
   (normalize "pubdate")
   (normalize "abstract")

   (normalize "copyright")
   (normalize "legalnotice")))

(define (article-titlepage-verso-elements)
  (list
   (normalize "revhistory")
   ))

;; display URL on line following CorpAuthor's name
(element (corpauthor ulink)
  (make sequence
    (process-children)
    (make paragraph
      font-size: (HSIZE 2)
      font-weight: 'medium
      (literal (attribute-string (normalize "url"))))))

(mode article-titlepage-recto-mode
  ;; FIXME: move most of this in "changes below" after parametrisation

  ;; suppress the silly "affiliation" empty paragraph for CorpAuthor
  (element corpauthor
    (make paragraph
      use: article-titlepage-recto-style
      font-size: (HSIZE 4)
;      line-spacing: (* (HSIZE 3) %line-spacing-factor%)
      space-after: 0pt
      space-before: (* (HSIZE 1) %head-before-factor%)
      quadding: %article-title-quadding%
      keep-with-next?: #t
      (process-children)))

  (element title 
    (make paragraph
      use: article-titlepage-recto-style
      font-size: (HSIZE 5)
      line-spacing: (* (HSIZE 5) %line-spacing-factor%)
;;;      space-before: (* (HSIZE 5) %head-before-factor%)
      space-before: 0pt
      quadding: %article-title-quadding%
      keep-with-next?: #t
      (with-mode title-mode
        (process-children-trim))))

  (element subtitle 
    (make paragraph
      use: article-titlepage-recto-style
      font-size: (HSIZE 4)
      line-spacing: (* (HSIZE 4) %line-spacing-factor%)
      space-before: (* %bf-size% %head-before-factor%)
      space-after: (* (HSIZE 4) %head-before-factor%)
      quadding: %article-subtitle-quadding%
      keep-with-next?: #t
      (process-children-trim)))

  (element contractsponsor
    (make paragraph
      use: article-titlepage-recto-style
      font-size: (HSIZE 5)
      line-spacing: (* (HSIZE 5) %line-spacing-factor%)
      space-before: (* (HSIZE 5) %head-before-factor%)
      quadding: %article-title-quadding%
      keep-with-next?: #t
      (with-mode title-mode
        (process-children-trim))))

  (element author
    (let* ((author-name  (author-string))
	   (author-affil (select-elements (children (current-node)) 
					  (normalize "affiliation")))
	   (author-email (select-elements (descendants author-affil)
					  (normalize "email")))
	   (author-org (select-elements (descendants author-affil)
					  (normalize "orgname")))
	   )
      (make sequence
	use: set-titlepage-recto-style
	quadding: %division-title-quadding%
;;;	line-spacing: (* (HSIZE 3) %line-spacing-factor%)
;;;	space-before: (* (HSIZE 2) %head-before-factor%)
	
	(if (first-sibling? (current-node))
	    (make paragraph
	      keep-with-next?: #t
	      (literal (gentext-alcove-authors)))
	    (empty-sosofo))

	(make paragraph
	  font-size: %bf-size%
	  keep-with-next?: #t

	  (make sequence
	    (literal author-name)
	    (if (node-list-empty? author-org)
		(empty-sosofo)
		(make sequence
		  (literal ", ")
		  (literal (data author-org))))
	    (if (node-list-empty? author-email)
		(empty-sosofo)
		(make sequence
		  (literal " <")
		  (literal (data author-email))
		  (literal ">")))
	    )))))
  
  (element address 
    (make display-group
      use: article-titlepage-recto-style
      space-before: 0pt
      font-weight: 'medium
      quadding: %article-title-quadding%
      (with-mode titlepage-address-mode 
        ($linespecific-display$ %indent-address-lines% %number-address-lines%))))

  (element legalnotice
    (make display-group
      use: article-titlepage-recto-style
      space-before: (* 2 (HSIZE 2) %head-before-factor%)
      (if %show-comments%
	  (make display-group
	    color: color-red
	    display-alignment: 'center
	    (literal "INTERNAL USE ONLY - CONTAINS PRIVATE REMARKS"))
	  ($semiformal-object$))))

  (element (legalnotice para)
    (make paragraph
      quadding: 'center
      font-size: %bf-size%
      (process-children)))

)

;; display revhistory as a table
(mode article-titlepage-verso-mode
  (element revhistory
    ($revhistory-table$))
  (element (revhistory revision)
    ($revhistory-table-revision$)))


;;
;; ToC
;;

(define %generate-article-toc% #t)
(define %generate-article-toc-on-titlepage% #f)
(define %generate-fr-toc-in-front% #t)

;; should get parameters for the following
<!-- (see http://sf.net/tracker/index.php?func=detail&aid=439079&group_id=21935&atid=373750) -->
(define (toc-depth nd)
  (if (string=? (gi nd) (normalize "book"))
      7
      2))

(define %admon-graphics% #t)


;;
;; Misc parameters
;;

(define %verbatim-size-factor% 1.1)
(define bop-footnotes #t)
(define %footnote-ulinks% #t)
(define %hyphenation% #t)

    </style-specification-body>
  </style-specification>

  <external-specification id="parent" document="parent.dsl">
</style-sheet>
