//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it 
//  and/or modify it under the terms of the GNU General 
//  Public License as published by the Free Software 
//  Foundation; either version 2 of the License, or  
//  (at your option) any later version.         
//==============================================

#ifndef CONFIGURATION_SETTINGGROUP_H
#define CONFIGURATION_SETTINGGROUP_H

//--------------------
//forward declarations
class QString;
class QTextStream;
class Setting;
//--------------------

//=====================================
/*! \brief SettingGroup contains settings which are releated.
 */
//=====================================
class SettingGroup
{
//------------------------------------------------------
public:
  ///Creates configuration variables using default avlues
  SettingGroup(QString name);
  
  ///Destructor
  ~SettingGroup();

  ///Returns group's name
  QString getName();
  
  ///Returns a setting value
  QString getValue(QString key);
  
  ///Sets a setting value, create new setting if setting not found
  void setValue(QString key, QString value);
  
  ///returns the next groupsetting
  SettingGroup* getNext();
  
  ///sets the next group setting
  void setNext(SettingGroup* next);

  //loads this group from file
  void loadSettings(QDomNode& node);
  
  ///writes out this group to file
  void saveSettings(QTextStream& stream);

  ///resets a setting to its default value
  void resetSetting(QString key);
//------------------------------------------------------
private:
  ///groups identifying name
  QString name;
  
  ///pointer to first setting in group
  Setting* firstSetting;
  
  ///pointer to last setting in group
  Setting* lastSetting;
  
  ///pointer to next settingroup
  SettingGroup* next;
};
//------------------------------------------------------

#endif //CONFIGURATION_SETTINGGROUP_H
